/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.treemap;

import com.jidesoft.treemap.AbstractTreeMapModel;
import com.jidesoft.treemap.Aggregation;
import com.jidesoft.treemap.AggregationFactory;
import com.jidesoft.treemap.MutableTreeMapNode;
import com.jidesoft.treemap.TreeMapField;
import com.jidesoft.treemap.TreeMapModel;
import com.jidesoft.treemap.TreeMapSettings;
import com.jidesoft.treemap.y;
import com.jidesoft.utils.TypeUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeMapNode<N extends AbstractTreeMapNode<N>>
implements MutableTreeMapNode<N> {
    private double a = 1.0;
    private Shape b;
    protected final TreeMapModel<N> _model;
    private Color c = Color.lightGray;
    private y d;
    private SoftReference<BufferedImage> e;
    private Map<Integer, Number> f;
    private N g;
    private int h;

    protected AbstractTreeMapNode(TreeMapModel<N> treeMapModel) {
        this._model = treeMapModel;
        this.h = 0;
    }

    public abstract int getChildCount();

    @Override
    public int getLevel() {
        return this.h;
    }

    public N getParent() {
        return this.g;
    }

    public boolean isRoot() {
        return this.g == null;
    }

    public abstract Iterable<N> getChildren();

    public AbstractTreeMapNode[] getPath() {
        block5: {
            AbstractTreeMapNode[] abstractTreeMapNodeArray;
            block3: {
                N n2;
                int n3;
                block4: {
                    N n4;
                    n3 = AbstractTreeMapModel.A;
                    n2 = n4 = this.getParent();
                    if (n3 != 0) break block4;
                    if (n2 == null) break block5;
                    n2 = n4;
                }
                int n5 = ((AbstractTreeMapNode)n2).getLevel();
                AbstractTreeMapNode[] abstractTreeMapNodeArray2 = new AbstractTreeMapNode[n5 + 2];
                AbstractTreeMapNode<N> abstractTreeMapNode = this;
                int n6 = n5 + 1;
                abstractTreeMapNodeArray2[n6] = this;
                --n6;
                while ((abstractTreeMapNode = abstractTreeMapNode.getParent()) != null) {
                    abstractTreeMapNodeArray = abstractTreeMapNodeArray2;
                    if (n3 == 0) {
                        abstractTreeMapNodeArray[n6] = abstractTreeMapNode;
                        --n6;
                        if (n3 == 0) continue;
                    }
                    break block3;
                }
                abstractTreeMapNodeArray = abstractTreeMapNodeArray2;
            }
            return abstractTreeMapNodeArray;
        }
        return new AbstractTreeMapNode[]{this};
    }

    public abstract void add(N var1);

    public void setParent(N n2) {
        this.g = n2;
        this.h = ((AbstractTreeMapNode)this.getParent()).getLevel() + 1;
    }

    public abstract N getChild(Object var1);

    public abstract Object getNodeName();

    public abstract int getRow();

    public String getLabelName() {
        block36: {
            Object object;
            block35: {
                int n2;
                block21: {
                    block22: {
                        block34: {
                            Class clazz;
                            block33: {
                                Class clazz2;
                                Object object2;
                                block29: {
                                    TreeMapField treeMapField;
                                    block30: {
                                        block32: {
                                            Object object3;
                                            block31: {
                                                Object object4;
                                                boolean bl;
                                                block25: {
                                                    block26: {
                                                        block28: {
                                                            Object object5;
                                                            block27: {
                                                                block23: {
                                                                    block24: {
                                                                        TreeMapSettings treeMapSettings;
                                                                        block12: {
                                                                            AbstractTreeMapNode abstractTreeMapNode;
                                                                            block14: {
                                                                                block13: {
                                                                                    block20: {
                                                                                        Class clazz3;
                                                                                        block19: {
                                                                                            Class clazz4;
                                                                                            Object object6;
                                                                                            block15: {
                                                                                                block16: {
                                                                                                    block18: {
                                                                                                        Object object7;
                                                                                                        block17: {
                                                                                                            Object object8;
                                                                                                            n2 = AbstractTreeMapModel.A;
                                                                                                            treeMapSettings = this._model.getSettings();
                                                                                                            if (n2 != 0) break block12;
                                                                                                            if (treeMapSettings.getBackgroundTreeMapField() == null) break block13;
                                                                                                            treeMapSettings = this._model.getSettings();
                                                                                                            if (n2 != 0) break block12;
                                                                                                            treeMapField = treeMapSettings.getBackgroundTreeMapField();
                                                                                                            if (!treeMapField.isValid()) break block13;
                                                                                                            abstractTreeMapNode = this;
                                                                                                            if (n2 != 0) break block14;
                                                                                                            if (!abstractTreeMapNode.isLeaf()) break block13;
                                                                                                            object6 = treeMapField.getType();
                                                                                                            if (n2 != 0) break block15;
                                                                                                            if (TypeUtils.isNumericType(object6)) break block16;
                                                                                                            object7 = object8 = this._model.getValueAt(this, treeMapField.getIndex());
                                                                                                            if (n2 != 0) break block17;
                                                                                                            if (object7 == null) break block18;
                                                                                                            object7 = object8;
                                                                                                        }
                                                                                                        return object7.toString();
                                                                                                    }
                                                                                                    return null;
                                                                                                }
                                                                                                object6 = this._model.getValueAt(this, treeMapField.getIndex());
                                                                                            }
                                                                                            clazz3 = clazz4 = object6;
                                                                                            if (n2 != 0) break block19;
                                                                                            if (clazz3 == null) break block20;
                                                                                            clazz3 = clazz4;
                                                                                        }
                                                                                        return ((Object)clazz3).toString();
                                                                                    }
                                                                                    return null;
                                                                                }
                                                                                abstractTreeMapNode = this;
                                                                            }
                                                                            treeMapSettings = abstractTreeMapNode._model.getSettings();
                                                                        }
                                                                        object = treeMapSettings.getLabelsTreeMapFields();
                                                                        if (n2 != 0) break block21;
                                                                        if (object == null) break block22;
                                                                        object = this._model.getSettings().getLabelsTreeMapFields();
                                                                        if (n2 != 0) break block21;
                                                                        if (object.isEmpty()) break block22;
                                                                        treeMapField = this._model.getSettings().getLabelsTreeMapFields().get(0);
                                                                        object5 = treeMapField;
                                                                        if (n2 != 0) break block23;
                                                                        if (!object5.isValid()) break block24;
                                                                        bl = this.isLeaf();
                                                                        if (n2 != 0) break block25;
                                                                        if (bl) break block26;
                                                                    }
                                                                    object5 = this.getNodeName();
                                                                }
                                                                if (n2 != 0) break block27;
                                                                if (object5 == null) break block28;
                                                                object5 = this.getNodeName();
                                                            }
                                                            return object5.toString();
                                                        }
                                                        return null;
                                                    }
                                                    object2 = treeMapField.getType();
                                                    if (n2 != 0) break block29;
                                                    bl = TypeUtils.isNumericType(object2);
                                                }
                                                if (bl) break block30;
                                                object3 = object4 = this._model.getValueAt(this, treeMapField.getIndex());
                                                if (n2 != 0) break block31;
                                                if (object3 == null) break block32;
                                                object3 = object4;
                                            }
                                            return object3.toString();
                                        }
                                        return null;
                                    }
                                    object2 = this._model.getValueAt(this, treeMapField.getIndex());
                                }
                                clazz = clazz2 = object2;
                                if (n2 != 0) break block33;
                                if (clazz == null) break block34;
                                clazz = clazz2;
                            }
                            return ((Object)clazz).toString();
                        }
                        return null;
                    }
                    object = this.getNodeName();
                }
                if (n2 != 0) break block35;
                if (object == null) break block36;
                object = this.getNodeName();
            }
            return object.toString();
        }
        return null;
    }

    public Color getColor() {
        return this.c;
    }

    protected Number worldToNormalized(Number number, TreeMapField treeMapField) {
        block5: {
            Number number2;
            Double d2;
            Double d3;
            block6: {
                int n2;
                block4: {
                    n2 = AbstractTreeMapModel.A;
                    d3 = this._model.getNumericMin(treeMapField);
                    d2 = this._model.getNumericMax(treeMapField);
                    number2 = d3;
                    if (n2 != 0) break block4;
                    if (number2 == null) break block5;
                    number2 = d2;
                }
                if (n2 != 0) break block6;
                if (number2 == null) break block5;
                number2 = number;
            }
            if (number2 != null) {
                double d4 = d2 - d3;
                return (number.doubleValue() - d3) / d4;
            }
        }
        return null;
    }

    protected Number normalizedToWorld(Number number, TreeMapField treeMapField) {
        block5: {
            Number number2;
            Double d2;
            Double d3;
            block6: {
                int n2;
                block4: {
                    n2 = AbstractTreeMapModel.A;
                    d3 = this._model.getNumericMin(treeMapField);
                    d2 = this._model.getNumericMax(treeMapField);
                    number2 = d3;
                    if (n2 != 0) break block4;
                    if (number2 == null) break block5;
                    number2 = d2;
                }
                if (n2 != 0) break block6;
                if (number2 == null) break block5;
                number2 = number;
            }
            if (number2 != null) {
                double d4 = d2 - d3;
                return number.doubleValue() * d4 + d3;
            }
        }
        return null;
    }

    @Override
    public Object getAggregateValue(int n2) {
        block46: {
            boolean bl;
            int n3;
            block35: {
                block36: {
                    Object object;
                    int n4;
                    Aggregation aggregation;
                    block34: {
                        block37: {
                            int n5;
                            block33: {
                                n3 = AbstractTreeMapModel.A;
                                AbstractTreeMapNode abstractTreeMapNode = this;
                                if (n3 == 0) {
                                    if (abstractTreeMapNode.isLeaf()) {
                                        return this._model.getValueAt(this.getSelf(), n2);
                                    }
                                    abstractTreeMapNode = this;
                                }
                                Map<Integer, Number> map = abstractTreeMapNode.f;
                                if (n3 == 0) {
                                    if (map == null) {
                                        this.f = new HashMap<Integer, Number>();
                                    }
                                    map = this.f;
                                }
                                bl = map.containsKey(n2);
                                if (n3 == 0) {
                                    if (bl) {
                                        return this.f.get(n2);
                                    }
                                    bl = Number.class.isAssignableFrom(this._model.getColumnClass(n2));
                                }
                                if (n3 != 0) break block35;
                                if (!bl) break block36;
                                aggregation = this._model.getSettings().getFieldSettings(this._model.getTreeMapField(n2)).getAggregation();
                                if (aggregation != AggregationFactory.SUM_AGGREGATION) break block37;
                                int n6 = 0;
                                for (AbstractTreeMapNode abstractTreeMapNode2 : this.getChildren()) {
                                    n5 = this._model.getFilter().isValueFiltered((N)abstractTreeMapNode2) ? 1 : 0;
                                    if (n3 == 0) {
                                        if (n5 == 0) {
                                            ++n6;
                                        }
                                        if (n3 == 0) continue;
                                    }
                                    break block33;
                                }
                                n5 = n6;
                            }
                            Object object2 = new double[n5];
                            int n7 = 0;
                            for (AbstractTreeMapNode abstractTreeMapNode : this.getChildren()) {
                                block39: {
                                    Number number;
                                    Object object3;
                                    block38: {
                                        object3 = this._model.getFilter();
                                        if (n3 != 0) break block38;
                                        if (object3.isValueFiltered(abstractTreeMapNode)) break block39;
                                        object3 = abstractTreeMapNode.getAggregateValue(n2);
                                    }
                                    if ((number = (Number)object3) != null) {
                                        object2[n7] = number.doubleValue();
                                    }
                                    ++n7;
                                }
                                if (n3 == 0) continue;
                            }
                            Double d2 = aggregation.aggregate((double[])object2);
                            this.f.put(n2, d2);
                            return d2;
                        }
                        int n8 = 0;
                        for (AbstractTreeMapNode abstractTreeMapNode : this._model.preorderEnumeration(this.getSelf())) {
                            block41: {
                                Object object4;
                                block42: {
                                    boolean bl2;
                                    block40: {
                                        n4 = this._model.isLeaf(abstractTreeMapNode) ? 1 : 0;
                                        if (n3 != 0) break block34;
                                        if (n3 != 0) break block40;
                                        if (n4 == 0) break block41;
                                        object4 = this._model.getFilter();
                                        if (n3 != 0) break block42;
                                        bl2 = object4.isValueFiltered(abstractTreeMapNode);
                                    }
                                    if (bl2) break block41;
                                    object4 = this._model.getValueAt(abstractTreeMapNode, n2);
                                }
                                if ((object = (Number)object4) != null) {
                                    ++n8;
                                }
                            }
                            if (n3 == 0) continue;
                        }
                        n4 = n8;
                    }
                    Object object5 = new double[n4];
                    int n9 = 0;
                    for (AbstractTreeMapNode abstractTreeMapNode : this._model.preorderEnumeration(this.getSelf())) {
                        block44: {
                            Number number;
                            Object object6;
                            block45: {
                                boolean bl3;
                                block43: {
                                    bl3 = this._model.isLeaf(abstractTreeMapNode);
                                    if (n3 != 0) break block43;
                                    if (!bl3) break block44;
                                    object6 = this._model.getFilter();
                                    if (n3 != 0) break block45;
                                    bl3 = object6.isValueFiltered(abstractTreeMapNode);
                                }
                                if (bl3) break block44;
                                object6 = this._model.getValueAt(abstractTreeMapNode, n2);
                            }
                            if ((number = (Number)object6) != null && n9 < ((Object)object5).length) {
                                object5[n9] = number.doubleValue();
                                ++n9;
                            }
                        }
                        if (n3 == 0) continue;
                    }
                    object = aggregation.aggregate((double[])object5);
                    this.f.put(n2, (Number)object);
                    return object;
                }
                bl = String.class.isAssignableFrom(this._model.getColumnClass(n2));
            }
            if (!bl) break block46;
            String string = null;
            for (AbstractTreeMapNode abstractTreeMapNode : this.getChildren()) {
                block48: {
                    String string2;
                    String string3;
                    block49: {
                        block50: {
                            Object object;
                            block47: {
                                object = this._model.getFilter();
                                if (n3 != 0) break block47;
                                if (object.isValueFiltered(abstractTreeMapNode)) break block48;
                                object = abstractTreeMapNode.getAggregateValue(n2);
                            }
                            string3 = (String)object;
                            string2 = string;
                            if (n3 != 0) break block49;
                            if (string2 != null) break block50;
                            string = string3;
                            if (n3 == 0) break block48;
                        }
                        string2 = string;
                    }
                    if (!string2.equals(string3)) {
                        string = null;
                        break;
                    }
                }
                if (n3 == 0) continue;
            }
            return string;
        }
        return null;
    }

    @Override
    public double getSize() {
        return this.a;
    }

    @Override
    public void setSize(double d2) {
        this.a = d2;
    }

    @Override
    public Shape getShape() {
        return this.b;
    }

    @Override
    public void invalidateAggregation() {
        block3: {
            Map<Integer, Number> map;
            block2: {
                map = this.f;
                if (AbstractTreeMapModel.A != 0) break block2;
                if (map == null) break block3;
                map = this.f;
            }
            map.clear();
        }
    }

    @Override
    public void setColor(Color color) {
        block3: {
            block5: {
                BufferedImage bufferedImage;
                block4: {
                    BufferedImage bufferedImage2;
                    Object object;
                    int n2;
                    block2: {
                        n2 = AbstractTreeMapModel.A;
                        this.c = color;
                        object = this.e;
                        if (n2 != 0) break block2;
                        if (object == null) break block3;
                        object = this.e.get();
                    }
                    bufferedImage = bufferedImage2 = (BufferedImage)object;
                    if (n2 != 0) break block4;
                    if (bufferedImage == null) break block5;
                    bufferedImage = bufferedImage2;
                }
                bufferedImage.flush();
            }
            this.e = null;
        }
    }

    @Override
    public void setShape(Shape shape) {
        block4: {
            block7: {
                BufferedImage bufferedImage;
                block6: {
                    BufferedImage bufferedImage2;
                    Object object;
                    int n2;
                    block5: {
                        AbstractTreeMapNode abstractTreeMapNode;
                        block2: {
                            block3: {
                                n2 = AbstractTreeMapModel.A;
                                abstractTreeMapNode = this;
                                if (n2 != 0) break block2;
                                if (abstractTreeMapNode.b == null) break block3;
                                abstractTreeMapNode = this;
                                if (n2 != 0) break block2;
                                if (abstractTreeMapNode.b.equals(shape)) break block4;
                            }
                            this.b = shape;
                            this.d = null;
                            abstractTreeMapNode = this;
                        }
                        object = abstractTreeMapNode.e;
                        if (n2 != 0) break block5;
                        if (object == null) break block4;
                        object = this.e.get();
                    }
                    bufferedImage = bufferedImage2 = (BufferedImage)object;
                    if (n2 != 0) break block6;
                    if (bufferedImage == null) break block7;
                    bufferedImage = bufferedImage2;
                }
                bufferedImage.flush();
            }
            this.e = null;
        }
    }

    @Override
    public Rectangle2D getBounds() {
        block3: {
            Shape shape;
            block2: {
                shape = this.b;
                if (AbstractTreeMapModel.A != 0) break block2;
                if (shape == null) break block3;
                shape = this.b;
            }
            return shape.getBounds2D();
        }
        return null;
    }

    public String toString() {
        return this.getLabelName();
    }

    y a() {
        y y2;
        block7: {
            Rectangle rectangle;
            N n2;
            block11: {
                Shape shape;
                block9: {
                    block10: {
                        int n3;
                        block8: {
                            Object object;
                            block6: {
                                block5: {
                                    y y3;
                                    block4: {
                                        n3 = AbstractTreeMapModel.A;
                                        y3 = this.d;
                                        if (n3 != 0) break block4;
                                        if (y3 == null) break block5;
                                        y3 = this.d;
                                    }
                                    return y3;
                                }
                                y2 = null;
                                object = n2 = this.getParent();
                                if (n3 != 0) break block6;
                                if (object == null) break block7;
                                object = this;
                            }
                            shape = ((AbstractTreeMapNode)object).b;
                            if (n3 != 0) break block8;
                            if (shape == null) break block7;
                            shape = this.b;
                        }
                        if (n3 != 0) break block9;
                        if (!(shape instanceof Rectangle)) break block10;
                        rectangle = (Rectangle)this.b;
                        if (n3 == 0) break block11;
                    }
                    shape = this.b;
                }
                rectangle = shape.getBounds();
            }
            int n4 = rectangle.y;
            int n5 = rectangle.y + rectangle.height;
            int n6 = rectangle.x;
            int n7 = rectangle.x + rectangle.width;
            y2 = ((AbstractTreeMapNode)n2).getParent() == null ? new y(this._model, n6, n7, rectangle.width, n4, n5, rectangle.height) : new y(((AbstractTreeMapNode)n2).a(), this._model, n6, n7, rectangle.width, n4, n5, rectangle.height);
        }
        this.d = y2;
        return y2;
    }

    public BufferedImage getCushionImage() {
        BufferedImage bufferedImage;
        block8: {
            BufferedImage bufferedImage2;
            block9: {
                block11: {
                    int n2;
                    block10: {
                        Object object;
                        block4: {
                            block5: {
                                block7: {
                                    BufferedImage bufferedImage3;
                                    block6: {
                                        BufferedImage bufferedImage4;
                                        n2 = AbstractTreeMapModel.A;
                                        object = this.e;
                                        if (n2 != 0) break block4;
                                        if (object != null) break block5;
                                        bufferedImage3 = bufferedImage4 = this.b();
                                        if (n2 != 0) break block6;
                                        if (bufferedImage3 == null) break block7;
                                        this.e = new SoftReference<BufferedImage>(bufferedImage4);
                                        bufferedImage3 = bufferedImage4;
                                    }
                                    return bufferedImage3;
                                }
                                return null;
                            }
                            object = this.e.get();
                        }
                        bufferedImage = bufferedImage2 = (BufferedImage)object;
                        if (n2 != 0) break block8;
                        if (bufferedImage != null) break block9;
                        bufferedImage2 = this.b();
                        if (n2 != 0) break block10;
                        if (bufferedImage2 == null) break block11;
                        this.e = new SoftReference<BufferedImage>(bufferedImage2);
                    }
                    if (n2 == 0) break block9;
                }
                return null;
            }
            bufferedImage = bufferedImage2;
        }
        return bufferedImage;
    }

    private BufferedImage b() {
        Rectangle rectangle;
        block7: {
            Shape shape;
            block5: {
                block6: {
                    int n2 = AbstractTreeMapModel.A;
                    shape = this.b;
                    if (n2 == 0) {
                        if (shape == null) {
                            return null;
                        }
                        shape = this.b;
                    }
                    if (n2 != 0) break block5;
                    if (!(shape instanceof Rectangle)) break block6;
                    rectangle = (Rectangle)this.getShape();
                    if (n2 == 0) break block7;
                }
                shape = this.getShape();
            }
            rectangle = shape.getBounds();
        }
        int n3 = Math.max(1, rectangle.width);
        int n4 = Math.max(1, rectangle.height);
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        this.a().fillRaster(this._model, this.c, rectangle.x, rectangle.y, n3, n4, writableRaster, new int[n3 * n4 << 2]);
        return bufferedImage;
    }

    public Color getCushionColor() {
        Rectangle rectangle;
        block7: {
            Shape shape;
            block5: {
                block6: {
                    int n2 = AbstractTreeMapModel.A;
                    shape = this.b;
                    if (n2 == 0) {
                        if (shape == null) {
                            return null;
                        }
                        shape = this.b;
                    }
                    if (n2 != 0) break block5;
                    if (!(shape instanceof Rectangle)) break block6;
                    rectangle = (Rectangle)this.getShape();
                    if (n2 == 0) break block7;
                }
                shape = this.getShape();
            }
            rectangle = shape.getBounds();
        }
        int n3 = Math.max(1, rectangle.width);
        int n4 = Math.max(1, rectangle.height);
        return this.a().computeColor(this._model, this.c, rectangle.x, rectangle.y, n3, n4);
    }

    protected N getSelf() {
        return (N)this;
    }
}

