/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util.collections;

import com.jidesoft.thirdparty.prefuse.util.collections.PrimeFinder;

public abstract class AbstractHashMap {
    protected int distinct;
    protected int lowWaterMark;
    protected int highWaterMark;
    protected double minLoadFactor;
    protected double maxLoadFactor;
    protected static final int defaultCapacity = 277;
    protected static final double defaultMinLoadFactor = 0.2;
    protected static final double defaultMaxLoadFactor = 0.5;

    protected AbstractHashMap() {
    }

    protected int chooseGrowCapacity(int n2, double d2, double d3) {
        return this.nextPrime(Math.max(n2 + 1, (int)((double)(4 * n2) / (3.0 * d2 + d3))));
    }

    protected int chooseHighWaterMark(int n2, double d2) {
        return Math.min(n2 - 2, (int)((double)n2 * d2));
    }

    protected int chooseLowWaterMark(int n2, double d2) {
        return (int)((double)n2 * d2);
    }

    protected int chooseMeanCapacity(int n2, double d2, double d3) {
        return this.nextPrime(Math.max(n2 + 1, (int)((double)(2 * n2) / (d2 + d3))));
    }

    protected int chooseShrinkCapacity(int n2, double d2, double d3) {
        return this.nextPrime(Math.max(n2 + 1, (int)((double)(4 * n2) / (d2 + 3.0 * d3))));
    }

    public abstract void clear();

    public void ensureCapacity(int n2) {
    }

    public boolean isEmpty() {
        return this.distinct == 0;
    }

    protected int nextPrime(int n2) {
        return PrimeFinder.nextPrime(n2);
    }

    protected void setUp(int n2, double d2, double d3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Initial Capacity must not be less than zero: " + n2);
        }
        if (d2 < 0.0 || d2 >= 1.0) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + d2);
        }
        if (d3 <= 0.0 || d3 >= 1.0) {
            throw new IllegalArgumentException("Illegal maxLoadFactor: " + d3);
        }
        if (d2 >= d3) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + d2 + " and maxLoadFactor: " + d3);
        }
    }

    public int size() {
        return this.distinct;
    }

    public void trimToSize() {
    }
}

