/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.expression;

import com.jidesoft.thirdparty.prefuse.data.expression.AbstractPredicate;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.ExpressionVisitor;
import com.jidesoft.thirdparty.prefuse.data.expression.Predicate;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class CompositePredicate
extends AbstractPredicate {
    protected ArrayList m_clauses = new ArrayList(2);

    public CompositePredicate() {
    }

    public CompositePredicate(Predicate predicate, Predicate predicate2) {
        this.m_clauses.add(predicate);
        this.m_clauses.add(predicate2);
    }

    public void add(Predicate predicate) {
        if (this.m_clauses.contains(predicate)) {
            throw new IllegalArgumentException("Duplicate predicate.");
        }
        this.m_clauses.add(predicate);
        this.fireExpressionChange();
    }

    public boolean remove(Predicate predicate) {
        if (this.m_clauses.remove(predicate)) {
            this.fireExpressionChange();
            return true;
        }
        return false;
    }

    public void clear() {
        this.removeChildListeners();
        this.m_clauses.clear();
        this.fireExpressionChange();
    }

    public int size() {
        return this.m_clauses.size();
    }

    public Predicate get(int n2) {
        return (Predicate)this.m_clauses.get(n2);
    }

    public void set(Predicate predicate) {
        this.removeChildListeners();
        this.m_clauses.clear();
        this.m_clauses.add(predicate);
        if (this.hasListeners()) {
            this.addChildListeners();
        }
        this.fireExpressionChange();
    }

    public void set(Predicate[] predicateArray) {
        this.removeChildListeners();
        this.m_clauses.clear();
        for (int i2 = 0; i2 < predicateArray.length; ++i2) {
            if (this.m_clauses.contains(predicateArray)) continue;
            this.m_clauses.add(predicateArray[i2]);
        }
        if (this.hasListeners()) {
            this.addChildListeners();
        }
        this.fireExpressionChange();
    }

    public Predicate getSubPredicate(Predicate predicate) {
        CompositePredicate compositePredicate = null;
        try {
            compositePredicate = (CompositePredicate)this.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        for (int i2 = 0; i2 < this.m_clauses.size(); ++i2) {
            Predicate predicate2 = (Predicate)this.m_clauses.get(i2);
            if (predicate == predicate2) continue;
            compositePredicate.add(predicate2);
        }
        return compositePredicate;
    }

    public void visit(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visitExpression(this);
        Iterator iterator = this.m_clauses.iterator();
        while (iterator.hasNext()) {
            expressionVisitor.down();
            ((Expression)iterator.next()).visit(expressionVisitor);
            expressionVisitor.up();
        }
    }

    protected void addChildListeners() {
        Iterator iterator = this.m_clauses.iterator();
        while (iterator.hasNext()) {
            ((Expression)iterator.next()).addExpressionListener(this);
        }
    }

    protected void removeChildListeners() {
        Iterator iterator = this.m_clauses.iterator();
        while (iterator.hasNext()) {
            ((Expression)iterator.next()).removeExpressionListener(this);
        }
    }

    protected String toString(String string) {
        if (this.m_clauses.size() == 1) {
            return this.m_clauses.get(0).toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Iterator iterator = this.m_clauses.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

