/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class TextComponentSearchable
extends Searchable
implements DocumentListener,
PropertyChangeListener {
    private Highlighter.HighlightPainter _highlightPainter;
    private static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(204, 204, 255);
    private Color _highlightColor = null;
    private int _selectedIndex = -1;
    private HighlighCache _highlighCache = new HighlighCache();
    private String _text = null;

    public TextComponentSearchable(JTextComponent jTextComponent) {
        super(jTextComponent);
        this.installHighlightsRemover();
        this.setHighlightColor(DEFAULT_HIGHLIGHT_COLOR);
    }

    public void uninstallHighlightsRemover() {
        DelegateAction.restoreAction(this._component, 0, KeyStroke.getKeyStroke(27, 0));
    }

    public void installHighlightsRemover() {
        DelegateAction.replaceAction(this._component, 0, KeyStroke.getKeyStroke(27, 0), new DelegateAction(){
            private static final long serialVersionUID = 8572103995404313032L;

            public boolean isDelegateEnabled() {
                Iterator iterator;
                if (TextComponentSearchable.this._component instanceof JTextComponent && !(iterator = TextComponentSearchable.this._highlighCache.getAllHighlights()).hasNext()) {
                    return false;
                }
                return super.isDelegateEnabled();
            }

            public boolean delegateActionPerformed(ActionEvent actionEvent) {
                Iterator iterator;
                if (TextComponentSearchable.this._component instanceof JTextComponent && !(iterator = TextComponentSearchable.this._highlighCache.getAllHighlights()).hasNext()) {
                    return false;
                }
                TextComponentSearchable.this.removeAllHighlights();
                return true;
            }
        });
    }

    public void installListeners() {
        super.installListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().addDocumentListener(this);
            this._component.addPropertyChangeListener("document", this);
        }
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().removeDocumentListener(this);
            this._component.removePropertyChangeListener("document", this);
        }
    }

    protected void setSelectedIndex(int n2, boolean bl) {
        if (this._component instanceof JTextComponent) {
            if (n2 == -1) {
                this.removeAllHighlights();
                this._selectedIndex = -1;
                return;
            }
            if (!bl) {
                this.removeAllHighlights();
            }
            String string = this.getSearchingText();
            try {
                this.addHighlight(n2, string, bl);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    protected void addHighlight(final int n2, final String string, boolean bl) throws BadLocationException {
        if (this._component instanceof JTextComponent) {
            final JTextComponent jTextComponent = (JTextComponent)this._component;
            Object object = jTextComponent.getHighlighter().addHighlight(n2, n2 + string.length(), this._highlightPainter);
            this._highlighCache.addHighlight(object);
            this._selectedIndex = n2;
            if (!bl) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        TextComponentSearchable.this.scrollTextVisible(jTextComponent, n2, string.length());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private void scrollTextVisible(JTextComponent jTextComponent, int n2, int n3) {
        if (n2 != -1) {
            try {
                Rectangle rectangle = jTextComponent.modelToView(n2);
                if (rectangle == null) {
                    return;
                }
                Rectangle rectangle2 = jTextComponent.modelToView(n2 + n3);
                if (rectangle2 == null) {
                    return;
                }
                Rectangle rectangle3 = this._component.getVisibleRect();
                if (rectangle.x <= rectangle3.width) {
                    rectangle.width = rectangle2.x;
                    rectangle.x = 0;
                } else {
                    rectangle.width = rectangle2.x - rectangle.x;
                }
                jTextComponent.scrollRectToVisible(rectangle);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected void removeAllHighlights() {
        if (this._component instanceof JTextComponent) {
            Iterator iterator = this._highlighCache.getAllHighlights();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                ((JTextComponent)this._component).getHighlighter().removeHighlight(e2);
            }
            this._highlighCache.removeAllHighlights();
        }
    }

    protected int getSelectedIndex() {
        if (this._component instanceof JTextComponent) {
            return this._selectedIndex;
        }
        return 0;
    }

    protected Object getElementAt(int n2) {
        String string = this.getSearchingText();
        if (string != null && this._component instanceof JTextComponent) {
            int n3;
            int n4 = n2 + string.length();
            if (n4 > (n3 = this.getElementCount())) {
                n4 = this.getElementCount();
            }
            try {
                return ((JTextComponent)this._component).getDocument().getText(n2, n4 - n2 + 1);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return "";
    }

    protected int getElementCount() {
        if (this._component instanceof JTextComponent) {
            return ((JTextComponent)this._component).getDocument().getLength();
        }
        return 0;
    }

    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            if (propertyChangeEvent.getOldValue() instanceof Document) {
                ((Document)propertyChangeEvent.getNewValue()).removeDocumentListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof Document) {
                ((Document)propertyChangeEvent.getNewValue()).addDocumentListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    protected boolean isActivateKey(KeyEvent keyEvent) {
        if (this._component instanceof JTextComponent && ((JTextComponent)this._component).isEditable()) {
            return keyEvent.getID() == 401 && keyEvent.getKeyCode() == 70 && JideSwingUtilities.isMenuShortcutKeyDown(keyEvent);
        }
        return super.isActivateKey(keyEvent);
    }

    public Color getHighlightColor() {
        if (this._highlightColor != null) {
            return this._highlightColor;
        }
        return DEFAULT_HIGHLIGHT_COLOR;
    }

    public void setHighlightColor(Color color) {
        this._highlightColor = color;
        this._highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(this._highlightColor);
    }

    public int findLast(String string) {
        if (this._component instanceof JTextComponent) {
            String string2 = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return string2.lastIndexOf(string);
            }
            return TextComponentSearchable.lastIndexOf(string2, string, string2.length());
        }
        return super.findLast(string);
    }

    private String getDocumentText() {
        if (this._text == null) {
            Document document = ((JTextComponent)this._component).getDocument();
            try {
                String string;
                this._text = string = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }
        return this._text;
    }

    public int findFirst(String string) {
        if (this._component instanceof JTextComponent) {
            String string2 = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return string2.indexOf(string);
            }
            return TextComponentSearchable.indexOf(string2, string, 0);
        }
        return super.findFirst(string);
    }

    static int lastIndexOf(String string, String string2, int n2) {
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = n3 - n4;
        if (n2 < 0) {
            return -1;
        }
        if (n2 > n5) {
            n2 = n5;
        }
        if (n4 == 0) {
            return n2;
        }
        char[] cArray = string2.toLowerCase().toCharArray();
        char[] cArray2 = string2.toUpperCase().toCharArray();
        int n6 = n4 - 1;
        int n7 = n4 - 1;
        int n8 = n7 + n2;
        while (n8 >= n7) {
            while (n8 >= n7 && string.charAt(n8) != cArray[n6] && string.charAt(n8) != cArray2[n6]) {
                --n8;
            }
            if (n8 < n7) break;
            int n9 = n8 - 1;
            int n10 = n9 - (n4 - 1);
            int n11 = n6 - 1;
            while (n9 > n10) {
                char c2 = string.charAt(n9);
                if (c2 != cArray[n11] && c2 != cArray2[n11]) {
                    --n8;
                    break;
                }
                --n9;
                --n11;
            }
            if (n9 > n10) continue;
            return n10 + 1;
        }
        return -1;
    }

    private static int indexOf(String string, String string2, int n2) {
        int n3 = string.length();
        int n4 = string2.length();
        if (n2 >= n3) {
            return n4 == 0 ? n3 : -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 == 0) {
            return n2;
        }
        char[] cArray = string2.toLowerCase().toCharArray();
        char[] cArray2 = string2.toUpperCase().toCharArray();
        int n5 = n3 - n4;
        for (int i2 = n2; i2 <= n5; ++i2) {
            char c2;
            int n6;
            char c3 = string.charAt(i2);
            if (c3 != cArray[0] && c3 != cArray2[0]) {
                ++i2;
                while (i2 <= n5 && string.charAt(i2) != cArray[0] && string.charAt(i2) != cArray2[0]) {
                    ++i2;
                }
            }
            if (i2 > n5) continue;
            int n7 = n6 + n4 - 1;
            int n8 = 1;
            for (n6 = i2 + 1; n6 < n7 && ((c2 = string.charAt(n6)) == cArray[n8] || c2 == cArray2[n8]); ++n6) {
                ++n8;
            }
            if (n6 != n7) continue;
            return i2;
        }
        return -1;
    }

    public int findFromCursor(String string) {
        int n2;
        int n3;
        String string2;
        if (this.isCountMatch()) {
            string2 = this.getDocumentText();
            n3 = 0;
            this._matchCount = -1;
            do {
                n2 = n3;
                n3 = (this.isCaseSensitive() ? string2.indexOf(string, n2) : TextComponentSearchable.indexOf(string2, string, n2)) + 1;
                ++this._matchCount;
            } while (n3 > n2);
        }
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(string);
        }
        if (this._component instanceof JTextComponent) {
            int n4;
            string2 = this.getDocumentText();
            int n5 = n2 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n3 = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n6 = n4 = this.isCaseSensitive() ? string2.indexOf(string, n2) : TextComponentSearchable.indexOf(string2, string, n2);
            if (n4 == -1) {
                int n7 = n4 = this.isCaseSensitive() ? string2.indexOf(string, 0) : TextComponentSearchable.indexOf(string2, string, 0);
                if (n4 >= n2) {
                    n4 = -1;
                }
            }
            return n4;
        }
        return super.findFromCursor(string);
    }

    public int reverseFindFromCursor(String string) {
        if (!this.isReverseOrder()) {
            return this.findFromCursor(string);
        }
        if (this._component instanceof JTextComponent) {
            int n2;
            int n3;
            int n4;
            String string2 = this.getDocumentText();
            int n5 = n4 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n6 = n2 = this.isCaseSensitive() ? string2.lastIndexOf(string, n4) : TextComponentSearchable.lastIndexOf(string2, string, n4);
            if (n2 == -1) {
                int n7 = n2 = this.isCaseSensitive() ? string2.lastIndexOf(string, string2.length() - 1) : TextComponentSearchable.lastIndexOf(string2, string, string2.length() - 1);
                if (n2 <= n4) {
                    n2 = -1;
                }
            }
            return n2;
        }
        return super.findFromCursor(string);
    }

    public int findNext(String string) {
        if (this._component instanceof JTextComponent) {
            int n2;
            int n3;
            int n4;
            String string2 = this.getDocumentText();
            int n5 = n4 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n6 = n2 = this.isCaseSensitive() ? string2.indexOf(string, n4 + 1) : TextComponentSearchable.indexOf(string2, string, n4 + 1);
            if (n2 == -1 && this.isRepeats()) {
                int n7 = n2 = this.isCaseSensitive() ? string2.indexOf(string, 0) : TextComponentSearchable.indexOf(string2, string, 0);
                if (n2 > n4) {
                    n2 = -1;
                }
            }
            return n2;
        }
        return super.findNext(string);
    }

    public int findPrevious(String string) {
        if (this._component instanceof JTextComponent) {
            int n2;
            int n3;
            int n4;
            String string2 = this.getDocumentText();
            int n5 = n4 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n6 = n2 = this.isCaseSensitive() ? string2.lastIndexOf(string, n4 - 1) : TextComponentSearchable.lastIndexOf(string2, string, n4 - 1);
            if (n2 == -1 && this.isRepeats()) {
                int n7 = n2 = this.isCaseSensitive() ? string2.lastIndexOf(string, n3 - 1) : TextComponentSearchable.lastIndexOf(string2, string, n3 - 1);
                if (n2 < n4) {
                    n2 = -1;
                }
            }
            return n2;
        }
        return super.findPrevious(string);
    }

    public void hidePopup() {
        super.hidePopup();
        this._selectedIndex = -1;
    }

    protected void searchingTextEmpty() {
        this.setSelectedIndex(-1, false);
    }

    private class HighlighCache
    extends HashMap {
        private HighlighCache() {
        }

        public void addHighlight(Object object) {
            this.put(object, null);
        }

        public void removeHighlight(Object object) {
            this.remove(object);
        }

        public Iterator getAllHighlights() {
            return this.keySet().iterator();
        }

        public void removeAllHighlights() {
            this.clear();
        }
    }
}

