/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SoftHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 2456984612468446907L;
    private final Map<K, SoftReference<V>> hash = new HashMap<K, SoftReference<V>>();
    private final Map<SoftReference<V>, K> reverseLookup = new HashMap<SoftReference<V>, K>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    SoftHashMap() {
    }

    @Override
    public V get(Object object) {
        this.expungeStaleEntries();
        V v2 = null;
        SoftReference<V> softReference = this.hash.get(object);
        if (softReference != null && (v2 = (V)softReference.get()) == null) {
            this.hash.remove(object);
            this.reverseLookup.remove(softReference);
        }
        return v2;
    }

    private void expungeStaleEntries() {
        Reference<V> reference;
        while ((reference = this.queue.poll()) != null) {
            this.hash.remove(this.reverseLookup.remove(reference));
        }
    }

    @Override
    public V put(K k2, V v2) {
        this.expungeStaleEntries();
        SoftReference<V> softReference = new SoftReference<V>(v2, this.queue);
        this.reverseLookup.put((SoftReference<K>)softReference, (SoftReference<V>)k2);
        SoftReference<V> softReference2 = this.hash.put(k2, softReference);
        if (softReference2 == null) {
            return null;
        }
        return softReference2.get();
    }

    @Override
    public V remove(Object object) {
        this.expungeStaleEntries();
        SoftReference<V> softReference = this.hash.remove(object);
        if (softReference == null) {
            return null;
        }
        return softReference.get();
    }

    @Override
    public void clear() {
        this.hash.clear();
        this.reverseLookup.clear();
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.hash.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.expungeStaleEntries();
        LinkedHashSet<Map.Entry<K, V>> linkedHashSet = new LinkedHashSet<Map.Entry<K, V>>();
        for (final Map.Entry<K, SoftReference<V>> entry : this.hash.entrySet()) {
            final V v2 = entry.getValue().get();
            if (v2 == null) continue;
            linkedHashSet.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return entry.getKey();
                }

                @Override
                public V getValue() {
                    return v2;
                }

                @Override
                public V setValue(V v22) {
                    entry.setValue(new SoftReference(v22, SoftHashMap.this.queue));
                    return v2;
                }
            });
        }
        return linkedHashSet;
    }
}

