/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public abstract class NavigationComponentHelper {
    private int _rolloverRow = -1;
    private Point _mousePosition = null;

    protected abstract Rectangle getRowBounds(int var1);

    protected abstract int rowAtPoint(Point var1);

    protected abstract int[] getSelectedRows();

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int[] nArray;
        if (this._rolloverRow != -1) {
            this.paintRolloverRow(graphics, jComponent, this._rolloverRow);
        }
        if ((nArray = this.getSelectedRows()) != null) {
            for (int n2 : nArray) {
                this.paintSelectedRow(graphics, jComponent, n2);
            }
        }
    }

    protected void paintSelectedRow(Graphics graphics, JComponent jComponent, int n2) {
        Color color = this.getSelectionColor(jComponent);
        Rectangle rectangle = this.getRowBounds(n2);
        --rectangle.width;
        --rectangle.height;
        this.paintRow(graphics, n2, rectangle, color, 30, 70, 50, 128);
    }

    protected Color getSelectionColor(JComponent jComponent) {
        Color color = UIManager.getColor("NavigationComponent.selectionBackground");
        if (color == null) {
            color = UIManager.getColor("Tree.selectionBackground");
        }
        if (!jComponent.hasFocus() && Color.WHITE.equals(color = ColorUtils.toGrayscale(color).brighter())) {
            color = new Color(202, 202, 202);
        }
        return color;
    }

    protected void paintRolloverRow(Graphics graphics, JComponent jComponent, int n2) {
        Color color = UIManager.getColor("Tree.selectionBackground");
        Rectangle rectangle = this.getRowBounds(n2);
        if (rectangle == null) {
            return;
        }
        --rectangle.width;
        --rectangle.height;
        this.paintRow(graphics, n2, rectangle, color, 10, 40, 20, 100);
    }

    private void paintRow(Graphics graphics, int n2, Rectangle rectangle, Color color, int n3, int n4, int n5, int n6) {
        Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
        ((Graphics2D)graphics).setPaint(new LinearGradientPaint(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height, new float[]{0.5f, 0.95f, 1.0f}, new Color[]{new Color(color.getRed(), color.getGreen(), color.getBlue(), n3), new Color(color.getRed(), color.getGreen(), color.getBlue(), n4), new Color(color.getRed(), color.getGreen(), color.getBlue(), n5)}, MultipleGradientPaint.CycleMethod.NO_CYCLE));
        int n7 = 5;
        graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n7, n7);
        graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n6));
        graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n7, n7);
        JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
    }

    public void setup(final JComponent jComponent) {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                if (jComponent != null) {
                    NavigationComponentHelper.this._mousePosition = null;
                    int n2 = NavigationComponentHelper.this._rolloverRow;
                    NavigationComponentHelper.this._rolloverRow = -1;
                    if (n2 != -1) {
                        jComponent.repaint(NavigationComponentHelper.this.getRowBounds(n2));
                    }
                }
                NavigationComponentHelper.this.mouseExited(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                NavigationComponentHelper.this.mouseEntered(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                NavigationComponentHelper.this.mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                NavigationComponentHelper.this.mouseReleased(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                NavigationComponentHelper.this.mouseClicked(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (jComponent != null) {
                    int n2 = NavigationComponentHelper.this.rowAtPoint(mouseEvent.getPoint());
                    if (n2 != -1) {
                        int n3;
                        if (jComponent instanceof JTree) {
                            n3 = NavigationComponentHelper.this.getRowBounds((int)n2).height;
                            if (NavigationComponentHelper.this._mousePosition != null) {
                                jComponent.repaint(new Rectangle(((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.x - n3, ((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.y - n3, 2 * n3, 2 * n3));
                            }
                            NavigationComponentHelper.this._mousePosition = mouseEvent.getPoint();
                            if (NavigationComponentHelper.this._mousePosition != null) {
                                jComponent.repaint(new Rectangle(((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.x - n3, ((NavigationComponentHelper)NavigationComponentHelper.this)._mousePosition.y - n3, 2 * n3, 2 * n3));
                            }
                        }
                        if (NavigationComponentHelper.this._rolloverRow != n2) {
                            n3 = NavigationComponentHelper.this._rolloverRow;
                            NavigationComponentHelper.this._rolloverRow = n2;
                            if (n3 != -1) {
                                jComponent.repaint(NavigationComponentHelper.this.getRowBounds(n3));
                            }
                            jComponent.repaint(NavigationComponentHelper.this.getRowBounds(n2));
                        }
                    } else {
                        int n4 = NavigationComponentHelper.this._rolloverRow;
                        NavigationComponentHelper.this._rolloverRow = -1;
                        if (n4 != -1) {
                            jComponent.repaint(NavigationComponentHelper.this.getRowBounds(n4));
                        }
                    }
                }
                NavigationComponentHelper.this.mouseMoved(mouseEvent);
            }
        };
        jComponent.addMouseMotionListener(mouseInputAdapter);
        jComponent.addMouseListener(mouseInputAdapter);
        jComponent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                NavigationComponentHelper.this.repaintSelections(jComponent);
                NavigationComponentHelper.this.focusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                NavigationComponentHelper.this.repaintSelections(jComponent);
                NavigationComponentHelper.this.focusLost(focusEvent);
            }
        });
    }

    public void repaintSelections(JComponent jComponent) {
        int[] nArray = this.getSelectedRows();
        if (nArray != null) {
            for (int n2 : nArray) {
                Rectangle rectangle = this.getRowBounds(n2);
                rectangle.x = 0;
                rectangle.width = jComponent.getWidth();
                jComponent.repaint(rectangle);
            }
        }
        if (this._rolloverRow != -1) {
            jComponent.repaint(this.getRowBounds(this._rolloverRow));
        }
    }

    public int getRolloverRow() {
        return this._rolloverRow;
    }

    public void setRolloverRow(int n2) {
        this._rolloverRow = n2;
    }

    public Point getMousePosition() {
        return this._mousePosition;
    }
}

