/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Range;
import com.jidesoft.swing.JideSwingUtilities;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeRange
extends AbstractRange<Date> {
    protected Date _min;
    protected Date _max;
    private TimeZone timeZone = TimeZone.getDefault();

    public TimeRange() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l2 = calendar.getTimeInMillis();
        calendar.add(10, 24);
        long l3 = calendar.getTimeInMillis();
        this._min = new Date(l2);
        this._max = new Date(l3);
    }

    public TimeRange(Calendar calendar, Calendar calendar2) {
        this._min = calendar.getTime();
        this._max = calendar2.getTime();
        assert (calendar.before(calendar2));
    }

    public TimeRange(Date date, Date date2) {
        this._min = date;
        this._max = date2;
    }

    public TimeRange(long l2, long l3) {
        this._min = new Date(l2);
        this._max = new Date(l3);
    }

    public TimeRange(TimeRange timeRange) {
        this((long)timeRange.minimum(), (long)timeRange.maximum());
    }

    @Override
    public Range<Date> copy() {
        return new TimeRange(this);
    }

    public void setMin(Date date) {
        Date date2 = this._min;
        this._min = date;
        this.firePropertyChange("min", date2, this._min);
    }

    public void setMin(long l2) {
        Date date = this._min;
        this._min = new Date(l2);
        this.firePropertyChange("min", date, this._min);
    }

    @Override
    public void adjust(Date date, Date date2) {
        this.setMin(date);
        this.setMax(date2);
    }

    public void setMax(Date date) {
        Date date2 = this._max;
        this._max = date;
        this.firePropertyChange("max", date2, this._max);
    }

    public void setMax(long l2) {
        Date date = this._max;
        this._max = new Date(l2);
        this.firePropertyChange("max", date, this._max);
    }

    @Override
    public double minimum() {
        return this._min == null ? Double.MIN_VALUE : (double)this._min.getTime();
    }

    @Override
    public double maximum() {
        return this._max == null ? Double.MAX_VALUE : (double)this._max.getTime();
    }

    @Override
    public double size() {
        return this.maximum() - this.minimum();
    }

    @Override
    public Date lower() {
        return this._min;
    }

    @Override
    public Date upper() {
        return this._max;
    }

    @Override
    public boolean contains(Date date) {
        if (date == null) {
            return false;
        }
        long l2 = date.getTime();
        return (double)l2 >= this.minimum() && (double)l2 <= this.maximum();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public Range<Date> createIntermediate(Range<Date> range, double d2) {
        double d3 = this.minimum();
        double d4 = this.maximum();
        double d5 = range.minimum();
        double d6 = range.maximum();
        double d7 = d3 + d2 * (d5 - d3);
        double d8 = d4 + d2 * (d6 - d4);
        return new TimeRange((long)d7, (long)d8);
    }

    public static TimeRange union(TimeRange timeRange, TimeRange timeRange2) {
        if (timeRange == null) {
            return timeRange2;
        }
        if (timeRange2 == null) {
            return timeRange;
        }
        long l2 = timeRange._min == null ? Long.MAX_VALUE : timeRange._min.getTime();
        long l3 = timeRange2._min == null ? Long.MAX_VALUE : timeRange2._min.getTime();
        long l4 = timeRange._max == null ? Long.MIN_VALUE : timeRange._max.getTime();
        long l5 = timeRange2._max == null ? Long.MIN_VALUE : timeRange2._max.getTime();
        long l6 = Math.min(l2, l3);
        long l7 = Math.max(l4, l5);
        return new TimeRange(l6, l7);
    }

    public boolean equals(Object object) {
        if (object instanceof TimeRange) {
            TimeRange timeRange = (TimeRange)object;
            return JideSwingUtilities.equals(this._min, timeRange._min) && JideSwingUtilities.equals(this._max, timeRange._max);
        }
        return false;
    }

    public int hashCode() {
        return (this._max == null ? 0 : this._max.hashCode()) * 29 + (this._min == null ? 0 : this._min.hashCode());
    }

    public String toString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        return String.format("[%s, %s] rounded to [%s, %s]", this._min == null ? "null" : dateFormat.format(this._min), this._max == null ? "null" : dateFormat.format(this._max), this._min == null ? "null" : dateFormat.format(this.minimum()), this._max == null ? "null" : dateFormat.format(this.maximum()));
    }
}

