/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import com.jidesoft.range.TimeRange;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeMorpher {
    public static final String PROPERTY_MORPH_STARTED = "Morph Started";
    public static final String PROPERTY_MORPH_ENDED = "Morph Ended";
    public static final String PROPERTY_MORPH_RANGES = "Morph Ranges";
    private double position = 1.0;
    private int numSteps = 10;
    private int delay = 40;
    private int stepsLeft = this.numSteps;
    private Timer timer;
    private Range<?>[] ranges = null;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public RangeMorpher() {
    }

    public RangeMorpher(int n2, int n3) {
        this.numSteps = n2;
        this.stepsLeft = n2;
        this.delay = n3;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isMorphing() {
        return this.position < 1.0;
    }

    public void morph(final Range<?>[] rangeArray, final Range<?>[] rangeArray2) {
        this.stopAnimation();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RangeMorpher.this.stepsLeft--;
                RangeMorpher.this.position = (double)(RangeMorpher.this.numSteps - RangeMorpher.this.stepsLeft) / (double)RangeMorpher.this.numSteps;
                if (RangeMorpher.this.stepsLeft == 0) {
                    RangeMorpher.this.stopAnimation();
                    RangeMorpher.this.support.firePropertyChange(RangeMorpher.PROPERTY_MORPH_ENDED, RangeMorpher.this.ranges, rangeArray2);
                } else {
                    Range[] rangeArray3 = RangeMorpher.this.ranges;
                    RangeMorpher.access$402(RangeMorpher.this, RangeMorpher.this.createIntermediate(rangeArray, rangeArray2, RangeMorpher.this.position));
                    RangeMorpher.this.support.firePropertyChange(RangeMorpher.PROPERTY_MORPH_RANGES, rangeArray3, RangeMorpher.this.ranges);
                }
            }
        };
        this.timer = new Timer(this.delay, actionListener);
        this.timer.start();
        this.support.firePropertyChange(PROPERTY_MORPH_STARTED, null, rangeArray);
    }

    Range<?>[] createIntermediate(Range<?>[] rangeArray, Range<?>[] rangeArray2, double d2) {
        Range[] rangeArray3 = new Range[rangeArray.length];
        for (int i2 = 0; i2 < rangeArray3.length; ++i2) {
            if (!(rangeArray[i2] instanceof AbstractRange)) {
                throw new UnsupportedOperationException("Cannot morph " + rangeArray[i2].getClass().getName());
            }
            AbstractRange abstractRange = (AbstractRange)rangeArray[i2];
            rangeArray3[i2] = abstractRange.createIntermediate((AbstractRange)rangeArray2[i2], d2);
        }
        return rangeArray3;
    }

    Range<?> createIntermediate(NumericRange numericRange, NumericRange numericRange2, double d2) {
        double d3 = numericRange.minimum();
        double d4 = numericRange.maximum();
        double d5 = numericRange2.minimum();
        double d6 = numericRange2.maximum();
        double d7 = d3 + d2 * (d5 - d3);
        double d8 = d4 + d2 * (d6 - d4);
        return new NumericRange(d7, d8);
    }

    Range<?> createIntermediate(CategoryRange<?> categoryRange, CategoryRange<?> categoryRange2, double d2) {
        double d3 = categoryRange.minimum();
        double d4 = categoryRange.maximum();
        double d5 = categoryRange2.minimum();
        double d6 = categoryRange2.maximum();
        double d7 = d3 + d2 * (d5 - d3);
        double d8 = d4 + d2 * (d6 - d4);
        CategoryRange categoryRange3 = d2 < 0.5 ? new CategoryRange(categoryRange) : new CategoryRange(categoryRange2);
        categoryRange3.setMinimum(d7);
        categoryRange3.setMaximum(d8);
        return categoryRange3;
    }

    Range<?> createIntermediate(TimeRange timeRange, TimeRange timeRange2, double d2) {
        double d3 = timeRange.minimum();
        double d4 = timeRange.maximum();
        double d5 = timeRange2.minimum();
        double d6 = timeRange2.maximum();
        double d7 = d3 + d2 * (d5 - d3);
        double d8 = d4 + d2 * (d6 - d4);
        return new TimeRange((long)d7, (long)d8);
    }

    private void stopAnimation() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
            this.stepsLeft = this.numSteps;
        }
    }

    static /* synthetic */ Range[] access$402(RangeMorpher rangeMorpher, Range[] rangeArray) {
        rangeMorpher.ranges = rangeArray;
        return rangeArray;
    }
}

