/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerRange
extends AbstractNumericRange<Integer> {
    protected int _min;
    protected int _max;

    public IntegerRange() {
        this(0, 1);
    }

    public IntegerRange(int n2, int n3) {
        this._min = Math.min(n2, n3);
        this._max = Math.max(n2, n3);
    }

    public IntegerRange(IntegerRange integerRange) {
        this((int)integerRange.minimum(), (int)integerRange.maximum());
    }

    @Override
    public Range<Integer> copy() {
        return new IntegerRange(this);
    }

    @Override
    public double minimum() {
        return this._min;
    }

    @Override
    public double maximum() {
        return this._max;
    }

    public int getMin() {
        return this._min;
    }

    public void setMin(int n2) {
        int n3 = this._min;
        if (n3 == n2) {
            return;
        }
        assert (n2 <= this._max) : "minimum " + n2 + " not <= " + this._max;
        this._min = n2;
        this.firePropertyChange("min", n3, n2);
    }

    public int getMax() {
        return this._max;
    }

    public void setMax(int n2) {
        int n3 = this._max;
        if (n3 == n2) {
            return;
        }
        assert (n2 >= this._min) : "maximum " + n2 + " not >= " + this._min;
        this._max = n2;
        this.firePropertyChange("max", n3, n2);
    }

    @Override
    public void adjust(Integer n2, Integer n3) {
        this.setMin(n2);
        this.setMax(n3);
    }

    @Override
    public double size() {
        return this._max - this._min;
    }

    @Override
    public Integer lower() {
        return (int)this.minimum();
    }

    @Override
    public Integer upper() {
        return (int)this.maximum();
    }

    @Override
    public boolean contains(Integer n2) {
        return n2 >= this._min && n2 <= this._max;
    }

    @Override
    public Range<Integer> createIntermediate(Range<Integer> range, double d2) {
        double d3 = this.minimum();
        double d4 = this.maximum();
        double d5 = range.minimum();
        double d6 = range.maximum();
        double d7 = d3 + d2 * (d5 - d3);
        double d8 = d4 + d2 * (d6 - d4);
        return new IntegerRange((int)Math.round(d7), (int)Math.round(d8));
    }

    public boolean equals(Object object) {
        if (object instanceof IntegerRange) {
            IntegerRange integerRange = (IntegerRange)object;
            return this._min == integerRange._min && this._max == integerRange._max;
        }
        return false;
    }

    public int hashCode() {
        return this._max * 29 + this._min;
    }

    public String toString() {
        return String.format("#<IntegerRange min=%d max=%d>", this._min, this._max);
    }
}

