/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedNumericRange
extends AbstractNumericRange<Double> {
    private final Object monitor = new Object();
    private List<Range<Double>> _ranges = new ArrayList<Range<Double>>();
    private Double _max = null;
    private Double _min = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CombinedNumericRange add(Range<Double> range) {
        if (range == null) {
            return this;
        }
        Object object = this.monitor;
        synchronized (object) {
            this._ranges.add(range);
            this._min = null;
            this._max = null;
        }
        return this;
    }

    @Override
    public Double lower() {
        return this.minimum();
    }

    @Override
    public Double upper() {
        return this.maximum();
    }

    public int rangeCount() {
        return this._ranges == null ? 0 : this._ranges.size();
    }

    @Override
    public void adjust(Double d2, Double d3) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double maximum() {
        Object object = this.monitor;
        synchronized (object) {
            if (this._max != null) {
                return this._max;
            }
            if (this._ranges == null || this._ranges.size() == 0) {
                return Double.MAX_VALUE;
            }
            this._max = -1.7976931348623157E308;
            for (Range<Double> range : this._ranges) {
                if (range == null || !(range.maximum() > this._max)) continue;
                this._max = range.maximum();
            }
            return this._max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double minimum() {
        Object object = this.monitor;
        synchronized (object) {
            if (this._min != null) {
                return this._min;
            }
            if (this._ranges == null || this._ranges.size() == 0) {
                return -1.7976931348623157E308;
            }
            this._min = Double.MAX_VALUE;
            for (Range<Double> range : this._ranges) {
                if (range == null || !(range.minimum() < this._min)) continue;
                this._min = range.minimum();
            }
            return this._min;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Double d2) {
        Object object = this.monitor;
        synchronized (object) {
            if (d2 == null || this._ranges.size() == 0) {
                return false;
            }
            for (Range<Double> range : this._ranges) {
                if (!range.contains(d2)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double size() {
        Object object = this.monitor;
        synchronized (object) {
            return this.maximum() - this.minimum();
        }
    }

    public NumericRange getRange(double d2, double d3) {
        double d4 = this.maximum();
        double d5 = this.minimum();
        double d6 = Math.abs(d4 - d5);
        double d7 = d2 * d6;
        double d8 = d3 * d6;
        return new NumericRange(d5 - d7, d4 + d8);
    }

    @Override
    public Range<Double> createIntermediate(Range<Double> range, double d2) {
        double d3 = this.minimum();
        double d4 = this.maximum();
        double d5 = range.minimum();
        double d6 = range.maximum();
        double d7 = d3 + d2 * (d5 - d3);
        double d8 = d4 + d2 * (d6 - d4);
        return new NumericRange(d7, d8);
    }

    public String toString() {
        return String.format("#<CombinedNumericRange min=%s max=%s>", this.minimum(), this.maximum());
    }
}

