/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.popup;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.PopupUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Resizable;
import com.jidesoft.swing.ResizablePanel;
import com.jidesoft.swing.ResizableSupport;
import com.jidesoft.swing.ResizableWindow;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import sun.awt.EmbeddedFrame;

public class JidePopup
extends JComponent
implements Accessible,
WindowConstants {
    public static final String CLIENT_PROPERTY_WINDOW_OPACITY = "windowOpacity";
    public static final String CLIENT_PROPERTY_WINDOW_OPAQUE = "windowOpaque";
    public static final String CLIENT_PROPERTY_WINDOW_SHAPE = "windowShape";
    private static final String uiClassID = "JidePopupUI";
    private JRootPane rootPane;
    private boolean rootPaneCheckingEnabled = false;
    public static final String CONTENT_PANE_PROPERTY = "contentPane";
    public static final String MENU_BAR_PROPERTY = "JMenuBar";
    public static final String LAYERED_PANE_PROPERTY = "layeredPane";
    public static final String ROOT_PANE_PROPERTY = "rootPane";
    public static final String GLASS_PANE_PROPERTY = "glassPane";
    public static final String VISIBLE_PROPERTY = "visible";
    public static final String TRANSIENT_PROPERTY = "transient";
    public static final String ATTACHABLE_PROPERTY = "attachable";
    private boolean _attachable = true;
    public static final String MOVABLE_PROPERTY = "movable";
    private boolean _movable = false;
    private boolean _returnFocusToOwner = true;
    public static final String DETACHED_PROPERTY = "detached";
    public static final String CLIENT_PROPERTY_POPUP_TYPE = "popupType";
    public static final String CLIENT_PROPERTY_VALUE_POPUP_TYPE_COMBOBOX = "comboBox";
    protected boolean _detached;
    protected ResizableWindow _window;
    protected ResizablePanel _panel;
    protected ResizableSupport _resizableSupport;
    private ComponentAdapter _componentListener;
    private WindowAdapter _windowListener;
    private ComponentAdapter _ownerComponentListener;
    private HierarchyListener _hierarchyListener;
    private Point _displayStartLocation;
    public static final String CLIENT_PROPERTY_POPUP_ACTUAL_OWNER = "JidePopup.actualOwner";
    public static final String RESIZABLE_PROPERTY = "resizable";
    private boolean _resizable = true;
    private boolean _keepPreviousSize = true;
    public static final String OWNER_PROPERTY = "owner";
    private Component _owner;
    private Border _popupBorder;
    private boolean _transient = true;
    private int _timeout = 0;
    private Timer _timer;
    private Component _defaultFocusComponent;
    public static final int DO_NOTHING_ON_MOVED = -1;
    public static final int HIDE_ON_MOVED = 0;
    public static final int MOVE_ON_MOVED = 1;
    private int _defaultMoveOperation = 0;
    public int DISTANCE_TO_SCREEN_BORDER = 10;
    private List<Component> _excludedComponents;
    private int _gripperLocation = 1;
    public static final String PROPERTY_GRIPPER_LOCATION = "gripperLocation";
    private ComponentAdapter _popupResizeListener;
    protected Dimension _previousSize;
    protected Component _actualOwner;
    protected Point _actualOwnerLocation;
    public static final int LIGHT_WEIGHT_POPUP = 0;
    public static final int HEAVY_WEIGHT_POPUP = 2;
    private int _popupType = 2;
    private ActionListener _escapeActionListener;
    private Object HIDE_POPUP_KEY = null;
    protected Insets _insets = null;
    private boolean _isDragging = false;
    private double _relativeX;
    private double _relativeY;
    private Point _startPoint;
    private Window _currentWindow;
    private JPanel _currentPanel;
    private Insets _backToOriginalInsets = new Insets(10, 10, 10, 10);
    private AWTEventListener _awtEventListener;
    private static boolean checkedUnpostPopup;
    private static boolean unpostPopup;

    public JidePopup() {
        this._excludedComponents = new ArrayList<Component>();
        this.setRootPane(this.createRootPane());
        this.setLayout(new BorderLayout());
        this.setRootPaneCheckingEnabled(true);
        this.setFocusable(false);
        this.updateUI();
        this.initHidePopupProperty();
    }

    private void initHidePopupProperty() {
        Component[] componentArray;
        JComboBox jComboBox = new JComboBox();
        jComboBox.setEnabled(this.isEnabled());
        jComboBox.setEditable(true);
        jComboBox.doLayout();
        for (Component component : componentArray = jComboBox.getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            this.HIDE_POPUP_KEY = ((AbstractButton)component).getClientProperty("doNotCancelPopup");
            break;
        }
    }

    protected JRootPane createRootPane() {
        JRootPane jRootPane = new JRootPane();
        jRootPane.getContentPane().setLayout(new BorderLayout());
        jRootPane.setOpaque(false);
        return jRootPane;
    }

    public PopupUI getUI() {
        return (PopupUI)this.ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUI(PopupUI popupUI) {
        boolean bl = this.isRootPaneCheckingEnabled();
        try {
            this.setRootPaneCheckingEnabled(false);
            super.setUI(popupUI);
        }
        finally {
            this.setRootPaneCheckingEnabled(bl);
        }
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((PopupUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    protected void addImpl(Component component, Object object, int n2) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(component, object, n2);
        } else {
            super.addImpl(component, object, n2);
        }
    }

    public void remove(Component component) {
        int n2 = this.getComponentCount();
        super.remove(component);
        if (n2 == this.getComponentCount()) {
            this.getContentPane().remove(component);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.getJMenuBar();
        this.getRootPane().setJMenuBar(jMenuBar);
        this.firePropertyChange(MENU_BAR_PROPERTY, jMenuBar2, jMenuBar);
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        Container container2 = this.getContentPane();
        this.getRootPane().setContentPane(container);
        this.firePropertyChange(CONTENT_PANE_PROPERTY, container2, container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        JLayeredPane jLayeredPane2 = this.getLayeredPane();
        this.getRootPane().setLayeredPane(jLayeredPane);
        this.firePropertyChange(LAYERED_PANE_PROPERTY, jLayeredPane2, jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        Component component2 = this.getGlassPane();
        this.getRootPane().setGlassPane(component);
        this.firePropertyChange(GLASS_PANE_PROPERTY, component2, component);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.rootPane.removeAll();
            this.remove(this.rootPane);
        }
        JRootPane jRootPane2 = this.getRootPane();
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                this.setRootPaneCheckingEnabled(bl);
            }
        }
        this.firePropertyChange(ROOT_PANE_PROPERTY, jRootPane2, jRootPane);
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        if (bl != bl2) {
            super.setVisible(bl);
            this.firePropertyChange(VISIBLE_PROPERTY, bl2, bl);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePopup();
        }
        return this.accessibleContext;
    }

    public boolean isKeepPreviousSize() {
        return this._keepPreviousSize;
    }

    public void setKeepPreviousSize(boolean bl) {
        this._keepPreviousSize = bl;
    }

    public Insets getBackToOriginalInsets() {
        return this._backToOriginalInsets;
    }

    public void setBackToOriginalInsets(Insets insets) {
        this._backToOriginalInsets = insets;
    }

    public void showPopup() {
        this.showPopup(new Insets(0, 0, 0, 0), null);
    }

    public void showPopup(Component component) {
        this.showPopup(new Insets(0, 0, 0, 0), component);
    }

    public void showPopup(Insets insets) {
        this.showPopup(insets, null);
    }

    public void showPopup(Insets insets, Component component) {
        Component component2;
        this._insets = insets;
        Component component3 = component2 = component != null ? component : this.getOwner();
        if (component2 != null && component2.isShowing()) {
            Point point = component2.getLocationOnScreen();
            this.internalShowPopup(point.x, point.y, component2);
        } else {
            this.showPopup(0);
        }
    }

    protected Point getPopupLocation(Point point, Dimension dimension, Component component) {
        Dimension dimension2;
        Component component2 = component != null ? component : this.getOwner();
        Dimension dimension3 = dimension2 = component2 != null ? component2.getSize() : new Dimension(0, 0);
        if (dimension.width == 0) {
            dimension = this.getPreferredSize();
        }
        Point point2 = new Point(point.x + this._insets.left, point.y + dimension2.height - this._insets.bottom);
        int n2 = point2.x + dimension.width;
        int n3 = point2.y + dimension.height;
        Rectangle rectangle = PortingUtils.getContainingScreenBounds(new Rectangle(point2, dimension), true);
        if (n3 > rectangle.y + rectangle.height) {
            point2.y = point.y + this._insets.top - dimension.height;
            if (point2.y < rectangle.y) {
                point2.y = rectangle.y;
            }
            if (this.isResizable()) {
                this.setupResizeCorner(4);
            }
        } else if (this.isResizable()) {
            this.setupResizeCorner(16);
        }
        Rectangle rectangle2 = PortingUtils.containsInScreenBounds(component2, new Rectangle(point2, dimension));
        point2.x = rectangle2.x;
        point2.y = rectangle2.y;
        return point2;
    }

    public void setupResizeCorner(int n2) {
        switch (n2) {
            case 4: {
                if (this._resizableSupport == null) break;
                this._resizableSupport.getResizable().setResizableCorners(4);
                JideSwingUtilities.setRecursively(this, new JideSwingUtilities.Handler(){

                    public boolean condition(Component component) {
                        return component instanceof JideScrollPane;
                    }

                    public void action(Component component) {
                        Resizable.ResizeCorner resizeCorner = new Resizable.ResizeCorner(4);
                        resizeCorner.addMouseListener(JidePopup.this._resizableSupport.getResizable().getMouseInputAdapter());
                        resizeCorner.addMouseMotionListener(JidePopup.this._resizableSupport.getResizable().getMouseInputAdapter());
                        ((JideScrollPane)component).setScrollBarCorner("VERTICAL_TOP", resizeCorner);
                        ((JideScrollPane)component).setScrollBarCorner("VERTICAL_BOTTOM", null);
                    }

                    public void postAction(Component component) {
                    }
                });
                break;
            }
            case 16: {
                if (this._resizableSupport == null) break;
                this._resizableSupport.getResizable().setResizableCorners(16);
                JideSwingUtilities.setRecursively(this, new JideSwingUtilities.Handler(){

                    public boolean condition(Component component) {
                        return component instanceof JideScrollPane;
                    }

                    public void action(Component component) {
                        Resizable.ResizeCorner resizeCorner = new Resizable.ResizeCorner(16);
                        resizeCorner.addMouseListener(JidePopup.this._resizableSupport.getResizable().getMouseInputAdapter());
                        resizeCorner.addMouseMotionListener(JidePopup.this._resizableSupport.getResizable().getMouseInputAdapter());
                        ((JideScrollPane)component).setScrollBarCorner("VERTICAL_BOTTOM", resizeCorner);
                        ((JideScrollPane)component).setScrollBarCorner("VERTICAL_TOP", null);
                    }

                    public void postAction(Component component) {
                    }
                });
                break;
            }
            default: {
                if (this._resizableSupport == null) break;
                this._resizableSupport.getResizable().setResizableCorners(n2);
            }
        }
    }

    public static Component getTopLevelAncestor(Component component) {
        if (component == null) {
            return null;
        }
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof Window) && !(component2 instanceof Applet)) continue;
            return component2;
        }
        return null;
    }

    public void showPopup(int n2) {
        this.showPopup(n2, null);
    }

    public void showPopup(int n2, Component component) {
        this.setDetached(true);
        Rectangle rectangle = this.getDisplayScreenBounds(component);
        Dimension dimension = this.getSize();
        Dimension dimension2 = dimension.width == 0 ? this.getPreferredSize() : dimension;
        Point point = this.getDisplayStartLocation(rectangle, dimension2, n2);
        this.internalShowPopup(point.x, point.y, component);
    }

    public void setDisplayStartLocation(Point point) {
        this._displayStartLocation = point;
    }

    protected Point getDisplayStartLocation(Rectangle rectangle, Dimension dimension, int n2) {
        if (this._displayStartLocation != null) {
            return this._displayStartLocation;
        }
        switch (n2) {
            case 0: {
                return new Point(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            }
            case 5: {
                return new Point(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + rectangle.height - dimension.height - this.DISTANCE_TO_SCREEN_BORDER);
            }
            case 1: {
                return new Point(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + this.DISTANCE_TO_SCREEN_BORDER);
            }
            case 3: {
                return new Point(rectangle.x + rectangle.width - dimension.width - this.DISTANCE_TO_SCREEN_BORDER, rectangle.y + (rectangle.height - dimension.height) / 2);
            }
            case 7: {
                return new Point(rectangle.x + this.DISTANCE_TO_SCREEN_BORDER, rectangle.y + (rectangle.height - dimension.height) / 2);
            }
            case 6: {
                return new Point(rectangle.x + this.DISTANCE_TO_SCREEN_BORDER, rectangle.y + rectangle.height - dimension.height - this.DISTANCE_TO_SCREEN_BORDER);
            }
            case 2: {
                return new Point(rectangle.x + rectangle.width - dimension.width - this.DISTANCE_TO_SCREEN_BORDER, rectangle.y + this.DISTANCE_TO_SCREEN_BORDER);
            }
            case 8: {
                return new Point(rectangle.x + this.DISTANCE_TO_SCREEN_BORDER, rectangle.y + this.DISTANCE_TO_SCREEN_BORDER);
            }
        }
        return new Point(rectangle.x + rectangle.width - dimension.width - this.DISTANCE_TO_SCREEN_BORDER, rectangle.y + rectangle.height - dimension.height - this.DISTANCE_TO_SCREEN_BORDER);
    }

    protected Rectangle getDisplayScreenBounds(Component component) {
        Rectangle rectangle;
        if (component != null && component.isShowing()) {
            rectangle = component.getBounds();
            Point point = component.getLocationOnScreen();
            rectangle.x = point.x;
            rectangle.y = point.y;
        } else {
            rectangle = this.getOwner() == null ? PortingUtils.getLocalScreenBounds() : PortingUtils.getScreenBounds(this.getOwner(), true);
        }
        return rectangle;
    }

    public void packPopup() {
        if (this._popupType == 0) {
            if (this._panel == null) {
                return;
            }
            this._panel.setSize(this._panel.getPreferredSize());
        } else if (this._popupType == 2) {
            if (this._window == null) {
                return;
            }
            this._window.pack();
        }
    }

    protected void internalShowPopup(int n2, int n3) {
        this.internalShowPopup(n2, n3, null);
    }

    protected void internalShowPopup(int n2, int n3, Component component) {
        Component component2 = this._actualOwner = component != null ? component : this.getOwner();
        if (this._actualOwner != null) {
            try {
                this._actualOwnerLocation = this._actualOwner.getLocationOnScreen();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                return;
            }
        }
        this.createWindow(this._actualOwner, n2, n3);
        this.showPopupImmediately();
    }

    protected Rectangle getAdjustedRectangle(int n2, int n3, Component component) {
        Serializable serializable;
        boolean bl = false;
        if (component instanceof JComponent) {
            for (serializable = (JComponent)component; serializable != null; serializable = (JComponent)((Component)serializable).getParent()) {
                Object object = ((JComponent)serializable).getClientProperty("useAllMonitorDevices");
                if (object instanceof Boolean) {
                    bl = (Boolean)object;
                    break;
                }
                if (!(((Component)serializable).getParent() instanceof JComponent)) break;
            }
        }
        serializable = this.getSize();
        return PortingUtils.containsInScreenBounds(component, new Rectangle(n2, n3, ((Dimension)serializable).width, ((Dimension)serializable).height), !bl);
    }

    protected void createWindow(Component component, int n2, int n3) {
        if (this._popupType == 0) {
            Serializable serializable;
            if (this._panel == null) {
                this._panel = this.createLightweightPopupContainer(component);
                this._resizableSupport = this._panel;
                this.installListeners();
                this.installBorder();
            }
            if (this._previousSize != null && this.isKeepPreviousSize()) {
                this.setPreferredSize(null);
                if (this._previousSize.width < 0) {
                    this._previousSize.width = this.getPreferredSize().width;
                }
                if (this._previousSize.height < 0) {
                    this._previousSize.height = this.getPreferredSize().height;
                }
                this.setPreferredSize(this._previousSize);
            }
            this._previousSize = null;
            this.packPopup();
            if (this._insets != null) {
                serializable = this.getPopupLocation(new Point(n2, n3), this._panel.getSize(), component);
                n2 = ((Point)serializable).x;
                n3 = ((Point)serializable).y;
            }
            if ((serializable = JideSwingUtilities.getOutermostRootPane(component)) == null) {
                return;
            }
            JLayeredPane jLayeredPane = serializable.getLayeredPane();
            Point point = new Point(n2, n3);
            SwingUtilities.convertPointFromScreen(point, jLayeredPane);
            jLayeredPane.add((Component)this._panel, JLayeredPane.PALETTE_LAYER);
            if (SystemInfo.isJdk15Above()) {
                jLayeredPane.setComponentZOrder(this._panel, 0);
            }
            this._panel.setLocation(point.x, point.y);
        } else if (this._popupType == 2) {
            if (this._window == null) {
                this._window = this.createHeavyweightPopupContainer(component);
                this._resizableSupport = this._window;
                this.installListeners();
                this.installBorder();
            }
            if (this._previousSize != null && this.isKeepPreviousSize()) {
                this.setPreferredSize(null);
                if (this._previousSize.width < 0) {
                    this._previousSize.width = this.getPreferredSize().width;
                }
                if (this._previousSize.height < 0) {
                    this._previousSize.height = this.getPreferredSize().height;
                }
                this.setPreferredSize(this._previousSize);
            }
            this._previousSize = null;
            this.packPopup();
            if (this._insets != null) {
                Point point = this.getPopupLocation(new Point(n2, n3), this._window.getSize(), component);
                n2 = point.x;
                n3 = point.y;
            }
            this._window.setLocation(n2, n3);
        }
    }

    public void showPopup(int n2, int n3) {
        this.showPopup(n2, n3, null);
    }

    public void showPopup(int n2, int n3, Component component) {
        this.internalShowPopup(n2, n3, component);
    }

    protected static Frame getFrame(Component component) {
        Component component2;
        for (component2 = component; !(component2 instanceof Frame) && component2 != null; component2 = component2.getParent()) {
        }
        return (Frame)component2;
    }

    protected ResizableWindow createHeavyweightPopupContainer(Component component) {
        Object object;
        Object object2;
        Object object3;
        ResizableWindow resizableWindow;
        Component component2 = JidePopup.getTopLevelAncestor(component);
        if (component2 instanceof Frame) {
            resizableWindow = new ResizableWindow((Frame)component2);
        } else if (component2 instanceof Window) {
            resizableWindow = new ResizableWindow((Window)component2);
        } else {
            object3 = JidePopup.getFrame(component);
            resizableWindow = new ResizableWindow((Frame)object3);
        }
        resizableWindow.setName("JidePopup");
        resizableWindow.getContentPane().add(this);
        object3 = this.getClientProperty(CLIENT_PROPERTY_WINDOW_OPAQUE);
        if (object3 instanceof Boolean) {
            JideSwingUtilities.setWindowOpaque(resizableWindow, (Boolean)object3);
        }
        if ((object2 = this.getClientProperty(CLIENT_PROPERTY_WINDOW_OPACITY)) instanceof Float) {
            JideSwingUtilities.setWindowOpacity(resizableWindow, ((Float)object2).floatValue());
        }
        if ((object = this.getClientProperty(CLIENT_PROPERTY_WINDOW_SHAPE)) instanceof Shape) {
            JideSwingUtilities.setWindowShape(resizableWindow, (Shape)object);
        }
        return resizableWindow;
    }

    protected ResizablePanel createLightweightPopupContainer(Component component) {
        ResizablePanel resizablePanel = new ResizablePanel(){

            protected Resizable createResizable() {
                return new Resizable(this){

                    public void resizing(int n2, int n3, int n4, int n5, int n6) {
                        this.setBounds(n3, n4, n5, n6);
                    }
                };
            }
        };
        resizablePanel.setVisible(false);
        resizablePanel.setOpaque(false);
        resizablePanel.setLayout(new BorderLayout());
        resizablePanel.add(this);
        return resizablePanel;
    }

    protected void installListeners() {
        Component component;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JidePopup.this.addMouseEventHandler();
            }
        });
        this._componentListener = new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                JidePopup.this.hidePopup();
            }
        };
        this._escapeActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JidePopup.this.hidePopupImmediately(true);
            }
        };
        this.registerKeyboardAction(this._escapeActionListener, KeyStroke.getKeyStroke(27, 0), 1);
        if (this._popupType == 2) {
            this._window.addComponentListener(this._componentListener);
            this._windowListener = new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    JidePopup.this.hidePopupImmediately(true);
                }
            };
            this._window.addWindowListener(this._windowListener);
        }
        if ((component = this.getActualOwner()) != null) {
            this._ownerComponentListener = new ComponentAdapter(){

                public void componentHidden(ComponentEvent componentEvent) {
                    JidePopup.this.ancestorHidden();
                }

                public void componentMoved(ComponentEvent componentEvent) {
                    try {
                        if (JidePopup.this._actualOwnerLocation == null || JidePopup.this._actualOwner == null || !JidePopup.this._actualOwner.getLocationOnScreen().equals(JidePopup.this._actualOwnerLocation)) {
                            JidePopup.this.ancestorMoved();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            component.addComponentListener(this._ownerComponentListener);
            this._hierarchyListener = new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    JidePopup.this.ancestorHidden();
                }
            };
            component.addHierarchyListener(this._hierarchyListener);
        }
        this._popupResizeListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JidePopup.this.removeComponentListener(JidePopup.this._popupResizeListener);
                JidePopup.this.contentResized();
                JidePopup.this.addComponentListener(JidePopup.this._popupResizeListener);
            }
        };
        this.addComponentListener(this._popupResizeListener);
    }

    protected void contentResized() {
        this.packPopup();
    }

    protected void installBorder() {
        if (!(this.getPopupBorder() == null || this._resizableSupport instanceof Component && this.getPopupBorder().getBorderInsets((Component)((Object)this._resizableSupport)) == null)) {
            if (this.isResizable()) {
                this._resizableSupport.getResizable().setResizableCorners(255);
            } else {
                this._resizableSupport.getResizable().setResizableCorners(0);
            }
            this._resizableSupport.setBorder(this.getPopupBorder());
        } else if (this.isDetached()) {
            if (this.isResizable()) {
                this._resizableSupport.getResizable().setResizableCorners(255);
            } else {
                this._resizableSupport.getResizable().setResizableCorners(0);
            }
            this._resizableSupport.setBorder(UIDefaultsLookup.getBorder("Resizable.resizeBorder"));
        } else {
            Border border;
            if (this.isResizable()) {
                this._resizableSupport.getResizable().setResizableCorners(56);
            } else {
                this._resizableSupport.getResizable().setResizableCorners(0);
            }
            if (!(CLIENT_PROPERTY_VALUE_POPUP_TYPE_COMBOBOX.equals(this.getClientProperty(CLIENT_PROPERTY_POPUP_TYPE)) || (border = UIDefaultsLookup.getBorder("PopupMenu.border")) == null || this._resizableSupport instanceof Component && border.getBorderInsets((Component)((Object)this._resizableSupport)) == null)) {
                this._resizableSupport.setBorder(border);
            }
        }
    }

    protected void showPopupImmediately() {
        boolean bl = true;
        if (this._popupType == 0) {
            if (this._panel == null) {
                return;
            }
            this._panel.applyComponentOrientation(this.getComponentOrientation());
            if (this._panel.isVisible()) {
                bl = false;
            }
            if (bl) {
                this.firePopupMenuWillBecomeVisible();
            }
            if (!this._panel.isVisible()) {
                this.packPopup();
                this._panel.setVisible(true);
            }
            if (bl) {
                this.firePropertyChange(VISIBLE_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            }
            if ((this.isFocusable() || this.getDefaultFocusComponent() != null) && this.getDefaultFocusComponent() != null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        Component component = JidePopup.this.getDefaultFocusComponent();
                        if (component instanceof JComponent) {
                            ((JComponent)component).requestFocus(true);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        } else if (this._popupType == 2) {
            Object object;
            if (this._window == null) {
                return;
            }
            if (this._window.isVisible()) {
                bl = false;
            }
            this._window.applyComponentOrientation(this.getComponentOrientation());
            if (bl) {
                this.firePopupMenuWillBecomeVisible();
            }
            if (!this.isFocusable() && this.getDefaultFocusComponent() == null) {
                this._window.setFocusableWindowState(false);
            } else {
                this.setFocusCycleRoot(true);
            }
            if (!this._window.isVisible()) {
                this._window.pack();
                this._window.setVisible(true);
            }
            if (bl) {
                this.firePropertyChange(VISIBLE_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            }
            if (this.isFocusable() || this.getDefaultFocusComponent() != null) {
                this._window.setFocusable(true);
                if (this.getDefaultFocusComponent() != null) {
                    object = new Runnable(){

                        public void run() {
                            Component component = JidePopup.this.getDefaultFocusComponent();
                            if (component instanceof JComponent) {
                                ((JComponent)component).requestFocus(true);
                            }
                        }
                    };
                    SwingUtilities.invokeLater((Runnable)object);
                }
            }
            if ((object = this.getRootPane().getDefaultButton()) != null) {
                this.getRootPane().setDefaultButton(null);
                this.getRootPane().setDefaultButton((JButton)object);
            }
        }
        if (this.getTimeout() != 0) {
            this.startTimeoutTimer();
        }
    }

    protected void movePopup() {
        if (this.isPopupVisible() && !this.isDetached() && this._actualOwner != null) {
            if (this._insets != null) {
                this.showPopup(this._insets, this._actualOwner);
            } else if (this._actualOwnerLocation != null) {
                Point point = this._actualOwner.getLocationOnScreen();
                Point point2 = null;
                if (this._popupType == 0) {
                    point2 = this._panel.getLocationOnScreen();
                } else if (this._popupType == 2 && (point2 = this._window.getLocationOnScreen()) != null) {
                    point2.x += point.x - this._actualOwnerLocation.x;
                    point2.y += point.y - this._actualOwnerLocation.y;
                }
                if (point2 != null) {
                    this.showPopup(point2.x, point2.y, this._actualOwner);
                }
            }
        }
    }

    protected void endDragging() {
        this._isDragging = false;
        if (this._popupType == 0) {
            this._currentPanel = null;
        } else if (this._popupType == 2) {
            if (this._currentWindow instanceof JWindow && ((JWindow)this._currentWindow).getGlassPane() != null) {
                ((JWindow)this._currentWindow).getGlassPane().setVisible(false);
                ((JWindow)this._currentWindow).getGlassPane().setCursor(Cursor.getDefaultCursor());
            } else if (this._currentWindow instanceof JDialog && ((JDialog)this._currentWindow).getGlassPane() != null) {
                ((JDialog)this._currentWindow).getGlassPane().setVisible(false);
                ((JDialog)this._currentWindow).getGlassPane().setCursor(Cursor.getDefaultCursor());
            }
            this._currentWindow = null;
        }
        this._relativeX = 0.0;
        this._relativeY = 0.0;
    }

    protected void beginDragging(JComponent jComponent, int n2, int n3, double d2, double d3) {
        this._relativeX = d2;
        this._relativeY = d3;
        Component component = this.getActualOwner();
        if (this._popupType == 0) {
            this._currentPanel = this._panel;
            this._isDragging = true;
            if (this.isDetached() && component != null) {
                this._startPoint = component.getLocationOnScreen();
                this._startPoint.y += component.getHeight();
            } else {
                this._startPoint = this._currentPanel.getLocationOnScreen();
            }
        } else if (this._popupType == 2) {
            if (jComponent.getTopLevelAncestor() instanceof JWindow) {
                this._currentWindow = (JWindow)jComponent.getTopLevelAncestor();
            }
            if (jComponent.getTopLevelAncestor() instanceof JDialog) {
                this._currentWindow = (JDialog)jComponent.getTopLevelAncestor();
            }
            if (this._currentWindow instanceof JWindow && ((JWindow)this._currentWindow).getGlassPane() != null) {
                ((JWindow)this._currentWindow).getGlassPane().setVisible(true);
                ((JWindow)this._currentWindow).getGlassPane().setCursor(Cursor.getPredefinedCursor(13));
            } else if (this._currentWindow instanceof JDialog && ((JDialog)this._currentWindow).getGlassPane() != null) {
                ((JDialog)this._currentWindow).getGlassPane().setVisible(true);
                ((JDialog)this._currentWindow).getGlassPane().setCursor(Cursor.getPredefinedCursor(13));
            }
            this._isDragging = true;
            if (this.isDetached() && component != null) {
                this._startPoint = component.getLocationOnScreen();
                this._startPoint.y += component.getHeight();
            } else {
                this._startPoint = this._currentWindow.getLocationOnScreen();
            }
        }
    }

    protected boolean isDragging() {
        return this._isDragging;
    }

    static void convertPointToScreen(Point point, Component component, boolean bl) {
        do {
            int n2;
            int n3;
            if (component instanceof JComponent) {
                n3 = component.getX();
                n2 = component.getY();
            } else if (component instanceof Applet || (bl ? component instanceof Window : component instanceof JFrame)) {
                try {
                    Point point2 = component.getLocationOnScreen();
                    n3 = point2.x;
                    n2 = point2.y;
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    n3 = component.getX();
                    n2 = component.getY();
                }
            } else {
                n3 = component.getX();
                n2 = component.getY();
            }
            point.x += n3;
            point.y += n2;
            if (!bl ? component instanceof JFrame : component instanceof Window) break;
        } while (!(component instanceof Applet) && (component = component.getParent()) != null);
    }

    protected void drag(JComponent jComponent, int n2, int n3, int n4) {
        if (this._popupType == 0) {
            int n5 = n2 - (int)((double)this._currentPanel.getWidth() * this._relativeX);
            int n6 = n3 - (int)((double)this._currentPanel.getHeight() * this._relativeY);
            Rectangle rectangle = new Rectangle(n5, n6, this._currentPanel.getWidth(), this._currentPanel.getHeight());
            Rectangle rectangle2 = PortingUtils.getScreenBounds(this._currentPanel, true);
            if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
                rectangle.y = rectangle2.y + rectangle2.height - rectangle.height;
            }
            if (rectangle.y < rectangle2.y) {
                rectangle.y = rectangle2.y;
            }
            if (this.isAttachable() && this.isWithinAroundArea(new Point(n5, n6), this._startPoint)) {
                Point point = new Point(this._startPoint);
                SwingUtilities.convertPointFromScreen(point, this._currentPanel.getParent());
                this._currentPanel.setLocation(point);
                this.setDetached(false);
            } else {
                Point point = new Point(n5, n6);
                SwingUtilities.convertPointFromScreen(point, this._currentPanel.getParent());
                this._currentPanel.setLocation(point);
                this.setDetached(true);
            }
        } else if (this._popupType == 2) {
            int n7 = n2 - (int)((double)this._currentWindow.getWidth() * this._relativeX);
            int n8 = n3 - (int)((double)this._currentWindow.getHeight() * this._relativeY);
            Rectangle rectangle = new Rectangle(n7, n8, this._currentWindow.getWidth(), this._currentWindow.getHeight());
            Rectangle rectangle3 = PortingUtils.getScreenBounds(this._currentWindow, true);
            if (rectangle.y + rectangle.height > rectangle3.y + rectangle3.height) {
                rectangle.y = rectangle3.y + rectangle3.height - rectangle.height;
            }
            if (rectangle.y < rectangle3.y) {
                rectangle.y = rectangle3.y;
            }
            if (this.isAttachable() && this.isWithinAroundArea(new Point(n7, n8), this._startPoint)) {
                this._currentWindow.setLocation(this._startPoint);
                this.setDetached(false);
            } else {
                this._currentWindow.setLocation(n7, n8);
                this.setDetached(true);
            }
        }
    }

    boolean isWithinAroundArea(Point point, Point point2) {
        if (this.getBackToOriginalInsets().left == 0 && this.getBackToOriginalInsets().top == 0 && this.getBackToOriginalInsets().right == 0 && this.getBackToOriginalInsets().bottom == 0) {
            return false;
        }
        Rectangle rectangle = new Rectangle(point.x - this.getBackToOriginalInsets().left, point.y - this.getBackToOriginalInsets().top, point.x + this.getBackToOriginalInsets().right, point.y + this.getBackToOriginalInsets().bottom);
        return rectangle.contains(point2);
    }

    /*
     * WARNING - void declaration
     */
    protected void handleMousePressed(MouseEvent mouseEvent) {
        Object object;
        MenuElement[] menuElementArray;
        Component component = mouseEvent.getComponent();
        if (component == null) {
            return;
        }
        Component component2 = (Component)mouseEvent.getSource();
        Object object2 = this.getClientProperty("popupMenuToCancel");
        if (component2 instanceof JComponent && this.HIDE_POPUP_KEY != null && object2 != null && ((JComponent)component2).getClientProperty("doNotCancelPopup") == this.HIDE_POPUP_KEY && this.isAncestorOf(component2) && (menuElementArray = ((MenuSelectionManager)(object = MenuSelectionManager.defaultManager())).getSelectedPath()) != null) {
            for (MenuElement menuElement : menuElementArray) {
                if (menuElement != object2) continue;
                ((MenuSelectionManager)object).clearSelectedPath();
                break;
            }
        }
        object = SwingUtilities.getDeepestComponentAt(component, mouseEvent.getX(), mouseEvent.getY());
        if (!this.isClickOnPopup(mouseEvent)) {
            if (this.isExcludedComponent((Component)object)) {
                return;
            }
            this.ancestorHidden();
        } else if (this.isPopupVisible()) {
            void var7_11;
            Window window;
            menuElementArray = SwingUtilities.convertPoint((Component)object, mouseEvent.getPoint(), this);
            Object var7_8 = null;
            if (this._popupType == 0) {
                Rectangle rectangle = this._panel.getBounds();
                Container container = this._panel.getParent();
                if (SystemInfo.isJdk15Above() && this.isClickOnPopup(mouseEvent) && container.getComponentZOrder(this._panel) != 0) {
                    container.setComponentZOrder(this._panel, 0);
                    container.repaint();
                }
            } else if (this._popupType == 2 && (window = SwingUtilities.getWindowAncestor((Component)object)) == this._window) {
                Rectangle rectangle = this._window.getBounds();
                if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() != this._window) {
                    this._window.toFront();
                }
            }
            if (var7_11 != null) {
                this._relativeX = (double)menuElementArray.x / (double)var7_11.width;
                this._relativeY = (double)menuElementArray.y / (double)var7_11.height;
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                JidePopup.convertPointToScreen(point, (Component)object, true);
                Component component3 = this.getUI().getGripper();
                if (component3 instanceof Container && (component3 == object || ((Container)component3).isAncestorOf((Component)object))) {
                    this.beginDragging(this, point.x, point.y, this._relativeX, this._relativeY);
                    mouseEvent.consume();
                }
            }
        }
    }

    protected void handleMouseReleased(MouseEvent mouseEvent) {
        if (this.isDragging()) {
            this.endDragging();
            mouseEvent.consume();
        }
    }

    protected void handleMouseDragged(MouseEvent mouseEvent) {
        if (this.isDragging()) {
            Point point = mouseEvent.getPoint();
            if (mouseEvent.getSource() instanceof Component) {
                JidePopup.convertPointToScreen(point, (Component)mouseEvent.getSource(), true);
                this.drag(null, point.x, point.y, mouseEvent.getModifiersEx());
                mouseEvent.consume();
            }
        }
    }

    protected void handleMouseEntered(MouseEvent mouseEvent) {
        if (this._popupType == 0) {
            if (this._panel != null && mouseEvent.getSource() instanceof Component && this._panel.isAncestorOf((Component)mouseEvent.getSource()) && this.getTimeout() != 0) {
                this.stopTimeoutTimer();
            }
        } else if (this._popupType == 2 && this._window != null && mouseEvent.getSource() instanceof Component && this._window.isAncestorOf((Component)mouseEvent.getSource()) && this.getTimeout() != 0) {
            this.stopTimeoutTimer();
        }
    }

    protected void handleMouseExited(MouseEvent mouseEvent) {
        if (this._popupType == 0) {
            if (this._panel != null && mouseEvent.getSource() instanceof Component && this._panel.isAncestorOf((Component)mouseEvent.getSource()) && this.getTimeout() != 0) {
                this.startTimeoutTimer();
            }
        } else if (this._popupType == 2 && this._window != null && mouseEvent.getSource() instanceof Component && this._window.isAncestorOf((Component)mouseEvent.getSource()) && this.getTimeout() != 0) {
            this.startTimeoutTimer();
        }
    }

    private static boolean doUnpostPopupOnDeactivation() {
        if (!checkedUnpostPopup) {
            unpostPopup = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    String string = "sun.swing.unpostPopupsOnWindowDeactivation";
                    String string2 = System.getProperty(string, "true");
                    return Boolean.valueOf(string2);
                }
            });
            checkedUnpostPopup = true;
        }
        return unpostPopup;
    }

    protected void handleWindowEvent(WindowEvent windowEvent) {
        Component component = this.getActualOwner();
        if (windowEvent.getSource() != this.getTopLevelAncestor() && windowEvent.getWindow() != null && (windowEvent.getWindow() == component || windowEvent.getWindow().isAncestorOf(component))) {
            if (windowEvent.getID() == 201 || windowEvent.getID() == 203) {
                this.hidePopup(true);
            } else if (this.isTransient() && windowEvent.getID() == 206 && !(windowEvent.getWindow() instanceof EmbeddedFrame) && JidePopup.doUnpostPopupOnDeactivation()) {
                JComponent jComponent;
                Window window = windowEvent.getOppositeWindow();
                if (window == this.getTopLevelAncestor()) {
                    return;
                }
                if (window instanceof RootPaneContainer && (jComponent = this.getRealParent((RootPaneContainer)((Object)window))) != null && jComponent.getTopLevelAncestor() == this.getTopLevelAncestor()) {
                    return;
                }
                this.hidePopup(true);
            }
        }
    }

    protected JComponent getRealParent(RootPaneContainer rootPaneContainer) {
        Object object;
        JComponent jComponent = JideSwingUtilities.getFirstJComponent(rootPaneContainer);
        if (jComponent != null && (object = jComponent.getClientProperty(CLIENT_PROPERTY_POPUP_ACTUAL_OWNER)) instanceof JComponent) {
            return (JComponent)object;
        }
        return null;
    }

    protected void handleComponentEvent(ComponentEvent componentEvent) {
        Component component = this.getActualOwner();
        if (!(componentEvent.getSource() instanceof Container)) {
            return;
        }
        Container container = (Container)componentEvent.getSource();
        if (componentEvent.getID() == 103 && (container == component || container.isAncestorOf(component))) {
            this.ancestorHidden();
        } else if (componentEvent.getID() == 100 && (container == component || container.isAncestorOf(component))) {
            try {
                if (this._actualOwnerLocation == null || this._actualOwner == null || !this._actualOwner.getLocationOnScreen().equals(this._actualOwnerLocation)) {
                    this.ancestorMoved();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void ancestorHidden() {
        if (this.isTransient()) {
            this.hidePopupImmediately(true);
        }
    }

    protected void ancestorMoved() {
        if (this.getDefaultMoveOperation() == 1) {
            this.movePopup();
        } else if (this.getDefaultMoveOperation() == 0 && this.isTransient()) {
            this.hidePopupImmediately(true);
        }
    }

    public void hidePopup() {
        this.hidePopup(false);
    }

    public void hidePopup(boolean bl) {
        if (!this.isPopupVisible()) {
            return;
        }
        this.hidePopupImmediately(bl);
    }

    public boolean isPopupVisible() {
        if (this._popupType == 0) {
            return this._panel != null && this._panel.isVisible();
        }
        if (this._popupType == 2) {
            return this._window != null && this._window.isShowing();
        }
        return false;
    }

    public Rectangle getPopupBounds() {
        if (this._popupType == 0) {
            return this.isPopupVisible() ? this._panel.getBounds() : null;
        }
        if (this._popupType == 2) {
            return this.isPopupVisible() ? this._window.getBounds() : null;
        }
        return null;
    }

    public void hidePopupImmediately(boolean bl) {
        Serializable serializable;
        Component component = this.getActualOwner();
        if (component != null) {
            component.removeHierarchyListener(this._hierarchyListener);
            this._hierarchyListener = null;
            component.removeComponentListener(this._ownerComponentListener);
            this._ownerComponentListener = null;
        }
        if (this._escapeActionListener != null) {
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
            this._escapeActionListener = null;
        }
        int n2 = 0;
        int n3 = 0;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            serializable = container.getInsets();
            if (serializable != null) {
                n2 += ((Insets)serializable).left + ((Insets)serializable).right;
                n3 += ((Insets)serializable).top + ((Insets)serializable).bottom;
            }
            if (container == this._window || container == this._panel) break;
        }
        if (this._window != null) {
            this._window.removeWindowListener(this._windowListener);
            this._windowListener = null;
            this._window.removeComponentListener(this._componentListener);
            this._componentListener = null;
            this._window.getContentPane().remove(this);
            if (bl) {
                this.firePopupMenuCanceled();
            }
            this.firePopupMenuWillBecomeInvisible();
        }
        if (this._panel != null) {
            this._panel.remove(this);
            if (bl) {
                this.firePopupMenuCanceled();
            }
            this.firePopupMenuWillBecomeInvisible();
        }
        if (this._popupResizeListener != null) {
            this.removeComponentListener(this._popupResizeListener);
            this._popupResizeListener = null;
        }
        if (component != null && this.isReturnFocusToOwner()) {
            component.requestFocus();
        }
        if (this._window != null) {
            this._previousSize = this._window.getSize();
            this._window.setVisible(false);
            this._window.removeAll();
            this._window.dispose();
            this._window = null;
            this.firePropertyChange(VISIBLE_PROPERTY, Boolean.TRUE, Boolean.FALSE);
        }
        if (this._panel != null) {
            this._previousSize = this._panel.getSize();
            this._panel.setVisible(false);
            serializable = this._panel.getParent();
            if (serializable != null) {
                ((Container)serializable).remove(this._panel);
            }
            this._panel = null;
            this.firePropertyChange(VISIBLE_PROPERTY, Boolean.TRUE, Boolean.FALSE);
        }
        if (this._previousSize != null) {
            this._previousSize.width -= n2;
            this._previousSize.height -= n3;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JidePopup.this.removeMouseEventHandler();
            }
        });
        this._resizableSupport = null;
        this._owner = null;
        this._actualOwner = null;
        this._actualOwnerLocation = null;
    }

    public void hidePopupImmediately() {
        this.hidePopupImmediately(false);
    }

    private void addMouseEventHandler() {
        if (this.shouldAWTEventListenerBeUsed()) {
            return;
        }
        if (this._awtEventListener == null) {
            this._awtEventListener = new AWTEventListener(){

                public void eventDispatched(AWTEvent aWTEvent) {
                    if ("sun.awt.UngrabEvent".equals(aWTEvent.getClass().getName())) {
                        JidePopup.this.hidePopupImmediately(true);
                        return;
                    }
                    if (aWTEvent instanceof MouseEvent) {
                        if (aWTEvent.getID() == 501) {
                            JidePopup.this.handleMousePressed((MouseEvent)aWTEvent);
                        } else if (aWTEvent.getID() == 506) {
                            JidePopup.this.handleMouseDragged((MouseEvent)aWTEvent);
                        } else if (aWTEvent.getID() == 502) {
                            JidePopup.this.handleMouseReleased((MouseEvent)aWTEvent);
                        } else if (aWTEvent.getID() == 504) {
                            JidePopup.this.handleMouseEntered((MouseEvent)aWTEvent);
                        } else if (aWTEvent.getID() == 505) {
                            JidePopup.this.handleMouseExited((MouseEvent)aWTEvent);
                        }
                    } else if (aWTEvent instanceof WindowEvent) {
                        JidePopup.this.handleWindowEvent((WindowEvent)aWTEvent);
                    } else if (aWTEvent instanceof ComponentEvent) {
                        JidePopup.this.handleComponentEvent((ComponentEvent)aWTEvent);
                    }
                }
            };
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Toolkit.getDefaultToolkit().addAWTEventListener(JidePopup.this._awtEventListener, 113L);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
    }

    protected boolean shouldAWTEventListenerBeUsed() {
        return SecurityUtils.isAWTEventListenerDisabled() || "true".equals(SecurityUtils.getProperty("jide.disableAWTEventListener", "false"));
    }

    private void removeMouseEventHandler() {
        if (this.shouldAWTEventListenerBeUsed()) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(JidePopup.this._awtEventListener);
                    JidePopup.this._awtEventListener = null;
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
    }

    public Component getOwner() {
        return this._owner;
    }

    public void setOwner(Component component) {
        if (this._owner != component) {
            Component component2 = this._owner;
            this._owner = component;
            this.firePropertyChange(OWNER_PROPERTY, component2, this._owner);
            this.removeExcludedComponent(component2);
            this.addExcludedComponent(this._owner);
        }
    }

    public boolean isMovable() {
        return this._movable;
    }

    public void setMovable(boolean bl) {
        boolean bl2 = this._movable;
        if (bl2 != bl) {
            this._movable = bl;
            this.firePropertyChange(MOVABLE_PROPERTY, bl2, this._movable);
        }
    }

    public boolean isResizable() {
        return this._resizable;
    }

    public void setResizable(boolean bl) {
        if (this._resizable != bl) {
            boolean bl2 = this._resizable;
            this._resizable = bl;
            this.firePropertyChange(RESIZABLE_PROPERTY, bl2, this._resizable);
        }
    }

    public boolean isAttachable() {
        return this._attachable;
    }

    public void setAttachable(boolean bl) {
        if (this._attachable != bl) {
            boolean bl2 = this._attachable;
            this._attachable = bl;
            this.firePropertyChange(ATTACHABLE_PROPERTY, bl2, this._attachable);
        }
    }

    public boolean isDetached() {
        return this._detached;
    }

    public void setDetached(boolean bl) {
        if (this._detached != bl) {
            boolean bl2 = this._detached;
            this._detached = bl;
            this.firePropertyChange("detacted", bl2, this._detached);
            if (this._resizableSupport != null) {
                if (this._detached) {
                    if (this.getPopupBorder() == null) {
                        this._resizableSupport.setBorder(UIDefaultsLookup.getBorder("Resizable.resizeBorder"));
                    } else {
                        this._resizableSupport.setBorder(this.getPopupBorder());
                    }
                    if (this.isResizable()) {
                        this._resizableSupport.getResizable().setResizableCorners(255);
                    } else {
                        this._resizableSupport.getResizable().setResizableCorners(0);
                    }
                } else {
                    if (this.getPopupBorder() == null) {
                        if (!CLIENT_PROPERTY_VALUE_POPUP_TYPE_COMBOBOX.equals(this.getClientProperty(CLIENT_PROPERTY_POPUP_TYPE))) {
                            this._resizableSupport.setBorder(UIDefaultsLookup.getBorder("PopupMenu.border"));
                        }
                    } else {
                        this._resizableSupport.setBorder(this.getPopupBorder());
                    }
                    if (this.isResizable()) {
                        this._resizableSupport.getResizable().setResizableCorners(56);
                    } else {
                        this._resizableSupport.getResizable().setResizableCorners(0);
                    }
                }
            }
        }
    }

    public Border getPopupBorder() {
        return this._popupBorder;
    }

    public void setPopupBorder(Border border) {
        this._popupBorder = border;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean bl) {
        boolean bl2 = this._transient;
        if (bl2 != bl) {
            this._transient = bl;
            this.firePropertyChange(TRANSIENT_PROPERTY, bl2, bl);
        }
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int n2) {
        this._timeout = n2;
        if (n2 != 0) {
            this.startTimeoutTimer();
        } else {
            this.stopTimeoutTimer();
        }
    }

    private void stopTimeoutTimer() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    private void startTimeoutTimer() {
        this.stopTimeoutTimer();
        this._timer = new Timer(this.getTimeout(), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JidePopup.this.hidePopup();
            }
        });
        this._timer.setRepeats(false);
        this._timer.start();
    }

    public Component getDefaultFocusComponent() {
        return this._defaultFocusComponent;
    }

    public void setDefaultFocusComponent(Component component) {
        this._defaultFocusComponent = component;
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(PopupMenuListener.class, popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(PopupMenuListener.class, popupMenuListener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(PopupMenuListener.class);
    }

    public void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
        }
    }

    public void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuCanceled(popupMenuEvent);
        }
    }

    public int getDefaultMoveOperation() {
        return this._defaultMoveOperation;
    }

    public void setDefaultMoveOperation(int n2) {
        this._defaultMoveOperation = n2;
    }

    public void addExcludedComponent(Component component) {
        if (component != null && !this._excludedComponents.contains(component)) {
            this._excludedComponents.add(component);
        }
    }

    public void removeExcludedComponent(Component component) {
        this._excludedComponents.remove(component);
    }

    public void removeAllExcludedComponents() {
        this._excludedComponents.clear();
    }

    public boolean isExcludedComponent(Component component) {
        boolean bl = this._excludedComponents.contains(component);
        if (!bl) {
            Component component2;
            Object object = this._excludedComponents.iterator();
            while (object.hasNext()) {
                component2 = object.next();
                if (!(component2 instanceof Container) || !((Container)component2).isAncestorOf(component)) continue;
                return true;
            }
            if (component instanceof JComponent && (object = ((JComponent)component).getTopLevelAncestor()) instanceof RootPaneContainer && (component2 = this.getRealParent((RootPaneContainer)object)) != null && ((JComponent)component2).getTopLevelAncestor() == this.getTopLevelAncestor()) {
                return true;
            }
        }
        return bl;
    }

    public int getGripperLocation() {
        return this._gripperLocation;
    }

    public void setGripperLocation(int n2) {
        int n3 = this._gripperLocation;
        if (n3 != n2) {
            this._gripperLocation = n2;
            this.firePropertyChange(PROPERTY_GRIPPER_LOCATION, n3, n2);
        }
    }

    public int getPopupType() {
        return this._popupType;
    }

    public void setPopupType(int n2) {
        if (n2 != 0 && n2 != 2) {
            throw new IllegalArgumentException("invalid popup type. It must be JidePopup.HEAVY_WEIGHT_POPUP or JidePopup.LIGHT_WEIGHT_POPUP.");
        }
        this._popupType = n2;
    }

    public boolean isClickOnPopup(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == null) {
            return false;
        }
        Component component2 = SwingUtilities.getDeepestComponentAt(component, mouseEvent.getX(), mouseEvent.getY());
        return this.getPopupType() == 2 ? this._window != null && (this._window == component2 || this._window.isAncestorOf(component2)) : this._panel != null && (this._panel == component2 || this._panel.isAncestorOf(component2));
    }

    protected Component getActualOwner() {
        if (this._actualOwner != null) {
            return this._actualOwner;
        }
        return this.getOwner();
    }

    public void setPreferredPopupSize(Dimension dimension) {
        this._previousSize = dimension;
    }

    public static boolean isPopupAncestorOf(JidePopup jidePopup, Component component) {
        Container container;
        if (component == null || (container = component.getParent()) == null) {
            return false;
        }
        while (container != null) {
            if (container == jidePopup) {
                return true;
            }
            if (container instanceof JidePopup) {
                return false;
            }
            container = container.getParent();
        }
        return false;
    }

    public boolean isReturnFocusToOwner() {
        return this._returnFocusToOwner;
    }

    public void setReturnFocusToOwner(boolean bl) {
        this._returnFocusToOwner = bl;
    }

    protected class AccessiblePopup
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -1095213042773793649L;

        protected AccessiblePopup() {
            super(JidePopup.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return JidePopup.this.getName();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            if (this.isVisible()) {
                return 1;
            }
            return 0;
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                if (number.intValue() == 0) {
                    this.setVisible(true);
                } else {
                    this.setVisible(false);
                }
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return Integer.MIN_VALUE;
        }

        public Number getMaximumAccessibleValue() {
            return Integer.MAX_VALUE;
        }
    }
}

