/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonUI;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;

public class BasicJideButtonListener
extends BasicButtonListener {
    private boolean _mouseOver = false;

    public BasicJideButtonListener(AbstractButton abstractButton) {
        super(abstractButton);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton.isRolloverEnabled()) {
            buttonModel.setRollover(true);
        }
        this._mouseOver = true;
        if (buttonModel.isPressed()) {
            buttonModel.setArmed(true);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if ("buttonStyle".equals(string) || "opaque".equals(string) || "contentAreaFilled".equals(string)) {
            AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
            abstractButton.repaint();
        } else if ("orientation".equals(string) || "hideActionText".equals(string)) {
            AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
            abstractButton.invalidate();
            abstractButton.repaint();
        } else if ("verticalTextPosition".equals(string) || "horizontalTextPosition".equals(string)) {
            AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
            abstractButton.updateUI();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        this.cancelMenuIfNecessary(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton.contains(mouseEvent.getPoint()) && abstractButton.isRolloverEnabled()) {
            buttonModel.setRollover(true);
        }
        if (!this._mouseOver) {
            buttonModel.setArmed(false);
            buttonModel.setPressed(false);
        }
        super.mouseReleased(mouseEvent);
        this.cancelMenuIfNecessary(mouseEvent);
    }

    private void cancelMenuIfNecessary(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        for (int i2 = menuElementArray.length - 1; i2 >= 0; --i2) {
            MenuElement menuElement = menuElementArray[i2];
            if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(abstractButton)) continue;
            abstractButton.getModel().setPressed(false);
            abstractButton.getModel().setArmed(false);
            abstractButton.getModel().setRollover(false);
            if (Boolean.FALSE.equals(abstractButton.getClientProperty("JideButton.hidePopupMenu"))) break;
            menuSelectionManager.clearSelectedPath();
            break;
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton.isRolloverEnabled()) {
            buttonModel.setRollover(false);
        }
        buttonModel.setArmed(false);
        this._mouseOver = false;
    }

    void updateMnemonicBinding(AbstractButton abstractButton) {
        int n2 = abstractButton.getMnemonic();
        if (n2 != 0) {
            InputMap inputMap = SwingUtilities.getUIInputMap(abstractButton, 2);
            if (inputMap == null) {
                inputMap = new ComponentInputMapUIResource(abstractButton);
                SwingUtilities.replaceUIInputMap(abstractButton, 2, inputMap);
            }
            inputMap.clear();
            inputMap.put(KeyStroke.getKeyStroke(n2, JideSwingUtilities.getFocusAcceleratorKeyMask(), false), "pressed");
            inputMap.put(KeyStroke.getKeyStroke(n2, JideSwingUtilities.getFocusAcceleratorKeyMask(), true), "released");
            inputMap.put(KeyStroke.getKeyStroke(n2, 0, true), "released");
        } else {
            InputMap inputMap = SwingUtilities.getUIInputMap(abstractButton, 2);
            if (inputMap != null) {
                inputMap.clear();
            }
        }
    }

    static Object getUIOfType(ComponentUI componentUI, Class clazz) {
        if (clazz.isInstance(componentUI)) {
            return componentUI;
        }
        return null;
    }

    public InputMap getInputMap(int n2, JComponent jComponent) {
        BasicJideButtonUI basicJideButtonUI;
        if (n2 == 0 && (basicJideButtonUI = (BasicJideButtonUI)BasicJideButtonListener.getUIOfType(((AbstractButton)jComponent).getUI(), BasicJideButtonUI.class)) != null) {
            return (InputMap)UIDefaultsLookup.get(basicJideButtonUI.getPropertyPrefix() + "focusInputMap");
        }
        return null;
    }

    public static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("pressed"));
        lazyActionMap.put(new Actions("released"));
    }

    public void installKeyboardActions(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        this.updateMnemonicBinding(abstractButton);
        LazyActionMap.installLazyActionMap(jComponent, BasicJideButtonListener.class, "JideButton.actionMap");
        InputMap inputMap = this.getInputMap(0, jComponent);
        SwingUtilities.replaceUIInputMap(jComponent, 0, inputMap);
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            String string = this.getName();
            if (PRESS.equals(string)) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                if (!abstractButton.hasFocus() && abstractButton.isRequestFocusEnabled()) {
                    abstractButton.requestFocus();
                }
            } else if (RELEASE.equals(string)) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            }
        }

        public boolean isEnabled(Object object) {
            return object == null || !(object instanceof AbstractButton) || ((AbstractButton)object).getModel().isEnabled();
        }
    }
}

