/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.basic.BasicFolderChooserUI;
import com.jidesoft.plaf.basic.LazyMutableTreeNode;
import com.jidesoft.swing.FolderChooser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.Icon;

class BasicFileSystemTreeNode
extends LazyMutableTreeNode
implements Comparable {
    private FolderChooser _folderChooser;
    private File _file;
    static HashMap _icons = new HashMap();
    static HashMap _nodes = new HashMap();

    protected BasicFileSystemTreeNode(File file) {
        this(file, null);
    }

    protected BasicFileSystemTreeNode(File file, FolderChooser folderChooser) {
        this._file = file;
        this._folderChooser = folderChooser;
    }

    public boolean isLeaf() {
        if (!this.isLoaded()) {
            return false;
        }
        return super.isLeaf();
    }

    public boolean hasChildren() {
        if (!this._loaded) {
            if (BasicFolderChooserUI.isFileSystem(this._file) && this._file.isDirectory()) {
                File[] fileArray;
                for (File file : fileArray = this._folderChooser.getFileSystemView().getFiles(this._file, this._folderChooser.isFileHidingEnabled())) {
                    if (!file.isDirectory()) continue;
                    return true;
                }
                this._loaded = true;
            }
            return false;
        }
        return this.getChildCount() != 0;
    }

    /*
     * WARNING - void declaration
     */
    protected void initChildren() {
        if (this._folderChooser == null) {
            return;
        }
        if (this._file.isDirectory()) {
            Object[] objectArray = new File[]{};
            try {
                void var5_10;
                objectArray = this._folderChooser.getFileSystemView().getFiles(this._file, this._folderChooser.isFileHidingEnabled());
                ArrayList arrayList = new ArrayList();
                Object[] object = objectArray;
                int n2 = object.length;
                boolean file = false;
                while (var5_10 < n2) {
                    File file2 = object[var5_10];
                    if (file2.isDirectory()) {
                        arrayList.add(file2);
                    }
                    ++var5_10;
                }
                objectArray = arrayList.toArray(new File[arrayList.size()]);
                Comparator<File> comparator = this._folderChooser.getFileComparator();
                if (comparator != null) {
                    Arrays.sort(objectArray, comparator);
                } else {
                    Arrays.sort(objectArray);
                }
            }
            catch (Error error) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (File file : objectArray) {
                BasicFileSystemTreeNode basicFileSystemTreeNode = BasicFileSystemTreeNode.createFileSystemTreeNode(file, this._folderChooser);
                this.add(basicFileSystemTreeNode);
            }
        }
    }

    public File getFile() {
        return this._file;
    }

    public String getName() {
        return this.getName(this.getFile());
    }

    public Icon getIcon() {
        Icon icon = (Icon)_icons.get(this);
        if (icon == null) {
            icon = this.getIcon(this.getFile());
            _icons.put(this, icon);
            return icon;
        }
        return icon;
    }

    public String getTypeDescription() {
        String string = this.getTypeDescription(this.getFile());
        return string == null ? "" : string;
    }

    public Icon getIcon(File file) {
        return this._folderChooser.getFileSystemView().getSystemIcon(file);
    }

    public String getTypeDescription(File file) {
        return this._folderChooser.getFileSystemView().getSystemTypeDescription(file);
    }

    public String getName(File file) {
        return this._folderChooser.getFileSystemView().getSystemDisplayName(file);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasicFileSystemTreeNode basicFileSystemTreeNode = (BasicFileSystemTreeNode)object;
        return !(this._file == null ? basicFileSystemTreeNode._file != null : !this._file.equals(basicFileSystemTreeNode._file));
    }

    public int compareTo(Object object) {
        if (!(object instanceof BasicFileSystemTreeNode)) {
            return 0;
        }
        return this.getFile().compareTo(((BasicFileSystemTreeNode)object).getFile());
    }

    public int hashCode() {
        return this._file != null ? this._file.hashCode() : 0;
    }

    public boolean canEnqueue() {
        return !this.isLoaded() && !this._folderChooser.getFileSystemView().isFloppyDrive(this.getFile()) && !this._folderChooser.getFileSystemView().isFileSystemRoot(this.getFile());
    }

    public String toString() {
        return this._file != null ? this._file.toString() : "null";
    }

    public static BasicFileSystemTreeNode createFileSystemTreeNode(File file, FolderChooser folderChooser) {
        BasicFileSystemTreeNode basicFileSystemTreeNode = (BasicFileSystemTreeNode)_nodes.get(file);
        if (basicFileSystemTreeNode == null) {
            basicFileSystemTreeNode = new BasicFileSystemTreeNode(file, folderChooser);
            _nodes.put(file, basicFileSystemTreeNode);
        }
        return basicFileSystemTreeNode;
    }

    public static void clearCache() {
        _nodes.clear();
    }
}

