/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.palette;

import com.jidesoft.palette.AbstractPalette;
import com.jidesoft.palette.FixedPalette;
import com.jidesoft.palette.Palette;
import com.jidesoft.palette.PaletteEvent;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpolatedPalette
extends FixedPalette {
    private Mode e = Mode.Ramps;
    private final SortedSet<Entry> f;

    public InterpolatedPalette(Palette palette) {
        this.f = new TreeSet<Entry>();
        for (int i2 = 0; i2 < palette.getColorCount(); ++i2) {
            Color color = palette.getColor(i2);
            this.f.add(new Entry((double)i2 / (double)(palette.getColorCount() - 1), color));
        }
        this.a();
    }

    public InterpolatedPalette(Entry ... entryArray) {
        this.f = new TreeSet<Entry>(Arrays.asList(entryArray));
        this.a();
    }

    private void a() {
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (int i2 = 0; i2 < 256; ++i2) {
            double d2 = 1.0 * (double)i2 / 255.0;
            Color color = this.a(d2);
            arrayList.add(color);
        }
        this._colors = arrayList;
        this._colorCount = this._colors.size();
        this.notifyPaletteChanged(new PaletteEvent());
    }

    @Override
    public Color getColor(double d2) {
        int n2 = AbstractPalette.c;
        int n3 = this.isInverted();
        int n4 = 0.a[this.getCycle().ordinal()];
        if (n2 == 0) {
            double d3;
            switch (n4) {
                case 1: {
                    int n5 = (int)d2 % 2;
                    if (n2 == 0) {
                        n5 = n5 == 0 ? 1 : 0;
                    }
                    n3 = n5;
                }
                case 2: {
                    d2 -= (double)((int)d2);
                }
            }
            n4 = (d3 = d2 - this.getLowestFraction()) == 0.0 ? 0 : (d3 < 0.0 ? -1 : 1);
        }
        if (n2 == 0) {
            if (n4 < 0) {
                return this.getColor(this.getLowestFraction());
            }
            double d4 = d2 - this.getHighestFraction();
            n4 = d4 == 0.0 ? 0 : (d4 > 0.0 ? 1 : -1);
        }
        if (n4 > 0) {
            return this.getColor(this.getHighestFraction());
        }
        Color color = this.a(n3 == 0 ? d2 : 1.0 - d2);
        return color;
    }

    private Color a(double d2) {
        if (!this.f.isEmpty()) {
            Entry entry = null;
            for (Entry entry2 : this.f) {
                if (entry != null && entry.getFraction() <= d2 && d2 <= entry2.getFraction()) {
                    double d3 = (d2 - entry.getFraction()) / (entry2.getFraction() - entry.getFraction());
                    return this.a(entry.getColor(), entry2.getColor(), d3);
                }
                entry = entry2;
            }
            if (d2 < this.f.first().getFraction()) {
                return this.f.first().getColor();
            }
            if (d2 > this.f.last().getFraction()) {
                return this.f.last().getColor();
            }
        }
        return null;
    }

    private Color a(Color color, Color color2, double d2) {
        switch (this.e) {
            case Ramps: {
                if (d2 == 0.0) {
                    return color;
                }
                if (d2 == 1.0) {
                    return color2;
                }
                return new Color((int)((double)color.getRed() * (1.0 - d2) + (double)color2.getRed() * d2), (int)((double)color.getGreen() * (1.0 - d2) + (double)color2.getGreen() * d2), (int)((double)color.getBlue() * (1.0 - d2) + (double)color2.getBlue() * d2), (int)((double)color.getAlpha() * (1.0 - d2) + (double)color2.getAlpha() * d2));
            }
            case Bands: {
                return color;
            }
        }
        return null;
    }

    public void setColor(double d2, Color color) {
        block6: {
            Entry entry;
            block5: {
                int n2 = AbstractPalette.c;
                entry = new Entry(d2, color);
                if (color == null) break block5;
                boolean bl = this.f.contains(entry);
                if (n2 == 0) {
                    if (bl) {
                        this.f.remove(entry);
                    }
                    bl = this.f.add(entry);
                }
                if (n2 == 0) break block6;
            }
            this.f.remove(entry);
        }
        this.notifyPaletteChanged(new PaletteEvent());
        this.a();
    }

    public Mode getMode() {
        return this.e;
    }

    public void setMode(Mode mode) {
        this.e = mode;
        this.notifyPaletteChanged(new PaletteEvent());
        this.a();
    }

    public Set<Entry> getEntries() {
        return this.f;
    }

    public void setEntries(Iterable<Entry> iterable) {
        block2: {
            int n2 = AbstractPalette.c;
            this.f.clear();
            for (Entry entry : iterable) {
                this.f.add(entry);
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            this.notifyPaletteChanged(new PaletteEvent());
            this.a();
        }
    }

    @Override
    protected double getLowestFraction() {
        InterpolatedPalette interpolatedPalette = this;
        if (AbstractPalette.c == 0) {
            if (!interpolatedPalette.f.isEmpty()) {
                return this.f.first().getFraction();
            }
            interpolatedPalette = this;
        }
        return super.getLowestFraction();
    }

    @Override
    protected double getHighestFraction() {
        InterpolatedPalette interpolatedPalette = this;
        if (AbstractPalette.c == 0) {
            if (!interpolatedPalette.f.isEmpty()) {
                return this.f.last().getFraction();
            }
            interpolatedPalette = this;
        }
        return super.getHighestFraction();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry
    implements Comparable<Entry> {
        private final double a;
        private final Color b;

        public Entry(double d2, Color color) {
            this.a = d2;
            this.b = color;
        }

        public double getFraction() {
            return this.a;
        }

        public Color getColor() {
            return this.b;
        }

        public boolean equals(Object object) {
            Object object2;
            int n2;
            block7: {
                block8: {
                    block6: {
                        n2 = AbstractPalette.c;
                        Object object3 = this;
                        if (n2 == 0) {
                            if (object3 == object) {
                                return true;
                            }
                            object3 = object;
                        }
                        if (object3 == null) break block6;
                        object2 = this.getClass();
                        if (n2 != 0) break block7;
                        if (object2 == object.getClass()) break block8;
                    }
                    return false;
                }
                object2 = object;
            }
            Entry entry = (Entry)object2;
            boolean bl = Double.compare(entry.a, this.a);
            if (n2 == 0) {
                bl = !bl;
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int hashCode() {
            double d2 = this.a;
            if (AbstractPalette.c == 0) {
                if (d2 == 0.0) return 0;
                d2 = this.a;
            }
            long l2 = Double.doubleToLongBits(d2);
            long l3 = l2;
            return (int)(l3 ^ l3 >>> 32);
        }

        @Override
        public int compareTo(Entry entry) {
            return Double.compare(this.a, entry.a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        Ramps,
        Bands;

    }
}

