/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class TintFilter
extends RGBImageFilter {
    private int _alpha;
    private int _red;
    private int _green;
    private int _blue;
    private int _width;
    private int _height;
    private Insets _insets;

    public TintFilter(Color color, int n2, int n3, Insets insets) {
        this._alpha = color.getAlpha();
        this._red = color.getRed();
        this._green = color.getGreen();
        this._blue = color.getBlue();
        this._width = n2;
        this._height = n3;
        this._insets = insets;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int n2, int n3, int n4) {
        if (this._insets != null && (n2 < this._insets.left || n2 > this._width - this._insets.right - 1 || n3 < this._insets.top || n3 > this._height - this._insets.bottom - 1)) {
            return n4;
        }
        Color color = new Color(n4, true);
        int n5 = Math.min(Math.max(color.getRed() + color.getRed() * this._red / 100, 0), 255);
        int n6 = Math.min(Math.max(color.getGreen() + color.getGreen() * this._green / 100, 0), 255);
        int n7 = Math.min(Math.max(color.getBlue() + color.getBlue() * this._blue / 100, 0), 255);
        int n8 = Math.min(Math.max(color.getAlpha() + color.getAlpha() * this._alpha / 100, 0), 255);
        return n8 << 24 | n5 << 16 | n6 << 8 | n7;
    }

    public static Image createTintedImage(Image image, Color color, Insets insets) {
        TintFilter tintFilter = new TintFilter(color, image.getWidth(null), image.getHeight(null), insets);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), tintFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }
}

