/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.LazyLoadDocument;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.search.FindAndReplaceTarget;
import com.jidesoft.search.FindResultIntepreter;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class CodeEditorFindAndReplaceTarget
implements FindAndReplaceTarget,
DocumentListener {
    private CodeEditor a;
    private boolean b = false;
    private int c;
    private DocumentListener[] d;

    public CodeEditorFindAndReplaceTarget(CodeEditor codeEditor) {
        this.a = codeEditor;
        this.a.getDocument().addDocumentListener(this);
    }

    public FindResultIntepreter getIntepreter() {
        return this.a;
    }

    public CodeEditor getCodeEditor() {
        return this.a;
    }

    public JComponent getConfigurationPanel() {
        return new JLabel(this.getResourceString("FindAndReplace.global"));
    }

    public boolean hasNext() {
        return false;
    }

    public void next() {
    }

    public boolean hasPrevious() {
        return false;
    }

    public void previous() {
    }

    public int getCurrentPosition(boolean bl) {
        int n2 = SyntaxDocument.e;
        int n3 = this.getCodeEditor().getSelectionModel().hasSelection();
        if (n2 == 0) {
            if (n3 != 0) {
                int n4 = bl;
                if (n2 == 0) {
                    n4 = n4 != 0 ? this.getCodeEditor().getSelectionEnd() : this.getCodeEditor().getSelectionStart();
                }
                return n4;
            }
            n3 = this.getCodeEditor().getCaretModel().getOffset();
        }
        return n3;
    }

    public void adjustCurrentPosition(String string, boolean bl) {
        block3: {
            int n2;
            block6: {
                int n3;
                block4: {
                    block5: {
                        int n4;
                        block2: {
                            n4 = SyntaxDocument.e;
                            n3 = this.getCodeEditor().getSelectionModel().hasSelection();
                            if (n4 != 0) break block2;
                            if (n3 == 0) break block3;
                            n3 = bl;
                        }
                        if (n4 != 0) break block4;
                        if (n3 == 0) break block5;
                        n2 = this.getCodeEditor().getSelectionStart();
                        if (n4 == 0) break block6;
                    }
                    n3 = this.getCodeEditor().getSelectionEnd();
                }
                n2 = n3;
            }
            this.getCodeEditor().select(n2, n2, true);
        }
    }

    public void highlight(int n2, int n3) {
        this.getCodeEditor().a(n2, n3, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int n2, int n3, String string) throws BadLocationException {
        this.getCodeEditor().getDocument().beginCompoundEdit();
        try {
            block5: {
                block4: {
                    this.getCodeEditor().getDocument().remove(n2, n3);
                    this.getCodeEditor().getDocument().insertString(n2, string, null);
                    this.getCodeEditor().getCaretModel().setOffset(n2 + string.length());
                    CodeEditorFindAndReplaceTarget codeEditorFindAndReplaceTarget = this;
                    if (SyntaxDocument.e != 0) break block4;
                    if (codeEditorFindAndReplaceTarget.c <= n2) break block5;
                    codeEditorFindAndReplaceTarget = this;
                }
                codeEditorFindAndReplaceTarget.c -= n3 - string.length();
            }
            Object var5_4 = null;
            this.getCodeEditor().getDocument().endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getCodeEditor().getDocument().endCompoundEdit();
            throw throwable;
        }
    }

    public Window getPromptDialogParent() {
        return JideSwingUtilities.getWindowForComponent(this.getCodeEditor());
    }

    public Point getPromptDialogLocation(Rectangle rectangle) {
        Point point;
        block6: {
            Point point2;
            block7: {
                int n2 = SyntaxDocument.e;
                CodeEditor codeEditor = this.getCodeEditor();
                if (n2 == 0) {
                    if (!codeEditor.isChangePromptDialogPosition()) {
                        return null;
                    }
                    codeEditor = this.getCodeEditor();
                }
                Point point3 = codeEditor.getCaretLocation();
                point = point2 = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), Math.min(point3.y + 50, this.getCodeEditor().getPainter().getHeight() - rectangle.height - 50));
                if (n2 != 0) break block6;
                if (point.y > point3.y) break block7;
                point = point2;
                if (n2 != 0) break block6;
                if (point.y + rectangle.height >= point3.y) {
                    point2.y = Math.max(0, point3.y - 50 - rectangle.height);
                }
            }
            SwingUtilities.convertPointToScreen(point2, this.getCodeEditor().getPainter());
            point = point2;
        }
        return point;
    }

    public Point getPromptDialogLocation() {
        Point point = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), this.getCodeEditor().lineToY(this.getCodeEditor().getFirstLine() + this.getCodeEditor().getVisibleLines() - 10));
        SwingUtilities.convertPointToScreen(point, this.getCodeEditor().getPainter());
        return point;
    }

    public void scrollToShowCaret(Rectangle rectangle) {
        block9: {
            int n2;
            int n3;
            int n4;
            block11: {
                block12: {
                    int n5;
                    block15: {
                        int n6;
                        int n7;
                        block13: {
                            block14: {
                                Point point;
                                block10: {
                                    int n8;
                                    int n9;
                                    block8: {
                                        n5 = SyntaxDocument.e;
                                        Point point2 = this.getCodeEditor().getCaretLocation();
                                        SwingUtilities.convertPointToScreen(point2, this.getCodeEditor().getPainter());
                                        n9 = rectangle.y;
                                        n8 = point2.y;
                                        if (n5 != 0) break block8;
                                        if (n9 > n8) break block9;
                                        point = point2;
                                        if (n5 != 0) break block10;
                                        n9 = point.y;
                                        n8 = rectangle.y + rectangle.height;
                                    }
                                    if (n9 > n8) break block9;
                                    point = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), this.getCodeEditor().lineToY(this.getCodeEditor().getFirstLine() + 5));
                                }
                                Point point3 = point;
                                SwingUtilities.convertPointToScreen(point3, this.getCodeEditor().getPainter());
                                n4 = this.getCodeEditor().getCaretModel().getViewPosition().line;
                                n3 = rectangle.y;
                                n2 = point3.y;
                                if (n5 != 0) break block11;
                                if (n3 > n2) break block12;
                                n3 = point3.y;
                                n2 = rectangle.y + rectangle.height;
                                if (n5 != 0) break block11;
                                if (n3 > n2) break block12;
                                Point point4 = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), this.getCodeEditor().lineToY(this.getCodeEditor().getFirstLine() + this.getCodeEditor().getVisibleLines() - 5));
                                SwingUtilities.convertPointToScreen(point4, this.getCodeEditor().getPainter());
                                n7 = rectangle.y;
                                n6 = point4.y;
                                if (n5 != 0) break block13;
                                if (n7 > n6) break block14;
                                n7 = point4.y;
                                n6 = rectangle.y + rectangle.height;
                                if (n5 != 0) break block13;
                                if (n7 <= n6) break block15;
                            }
                            n7 = n4;
                            n6 = this.getCodeEditor().getVisibleLines() - 5;
                        }
                        if (n7 >= n6) {
                            this.getCodeEditor().setFirstLine(n4 - this.getCodeEditor().getVisibleLines() + 5);
                        }
                    }
                    if (n5 == 0) break block9;
                }
                n3 = n4;
                n2 = 5;
            }
            if (n3 >= n2) {
                this.getCodeEditor().setFirstLine(n4 - 5);
            }
        }
    }

    public String getCurrentName() {
        return this.getCodeEditor().getName();
    }

    public CharSequence getCurrentText() {
        CharSequence charSequence;
        block4: {
            CodeEditor codeEditor;
            block2: {
                block3: {
                    int n2 = SyntaxDocument.e;
                    codeEditor = this.getCodeEditor();
                    if (n2 != 0) break block2;
                    if (!(codeEditor.getDocument() instanceof LazyLoadDocument)) break block3;
                    charSequence = ((LazyLoadDocument)this.getCodeEditor().getDocument()).getLazyLoadText();
                    if (n2 == 0) break block4;
                }
                codeEditor = this.getCodeEditor();
            }
            charSequence = codeEditor.getRawText();
        }
        this.setTargetChanged(false);
        return charSequence;
    }

    public void showMessage(String string) {
        this.getCodeEditor().showMessage(string);
    }

    public void replaceAllStarts() {
        block2: {
            int n2 = SyntaxDocument.e;
            this.getCodeEditor().getDocument().beginCompoundEdit();
            for (DocumentListener documentListener : this.d = this.getCodeEditor().getDocument().getDocumentListeners()) {
                this.getCodeEditor().getDocument().removeDocumentListener(documentListener);
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            this.c = this.getCodeEditor().getCaretModel().getOffset();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replaceAllEnds() {
        int n2 = SyntaxDocument.e;
        this.getCodeEditor().getDocument().endCompoundEdit();
        CodeEditorFindAndReplaceTarget codeEditorFindAndReplaceTarget = this;
        if (n2 == 0) {
            if (codeEditorFindAndReplaceTarget.d != null) {
                DocumentEvent documentEvent = this.getCodeEditor().createReplaceAllDocumentEvent();
                for (DocumentListener documentListener : this.d) {
                    this.getCodeEditor().getDocument().addDocumentListener(documentListener);
                    documentListener.changedUpdate(documentEvent);
                    if (n2 != 0) return;
                    if (n2 == 0) continue;
                }
            }
            codeEditorFindAndReplaceTarget = this;
        }
        int n3 = codeEditorFindAndReplaceTarget.c;
        if (n2 != 0 || n3 < 0) return;
        this.getCodeEditor().getCaretModel().setOffset(this.c);
        n3 = this.getCodeEditor().scrollToCaret() ? 1 : 0;
    }

    protected void setTargetChanged(boolean bl) {
        this.b = bl;
    }

    public boolean isTargetChanged() {
        return this.b;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setTargetChanged(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setTargetChanged(true);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public String getResourceString(String string) {
        return this.getCodeEditor().getResourceString(string);
    }

    public Locale getLocale() {
        return this.getCodeEditor().getLocale();
    }
}

