/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.Laziness;
import com.jidesoft.dialog.PageEvent;
import com.jidesoft.dialog.PageListener;
import java.awt.Graphics;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public abstract class AbstractPage
extends JPanel
implements Laziness {
    private static final long serialVersionUID = 3566789990192642869L;
    public static int INVOKE_ON_ALL = -1;
    public static int INVOKE_ON_NONE = 0;
    public static int INVOKE_ON_PAINT = 1;
    public static int INVOKE_ON_REPAINT = 2;
    public static int INVOKE_ON_UPDATE = 4;
    public static int INVOKE_ON_VALIDATE = 8;
    private boolean _allowClosing = true;
    private int _invokeCondition = INVOKE_ON_PAINT | INVOKE_ON_REPAINT | INVOKE_ON_UPDATE;
    protected transient PageEvent _pageEvent = null;
    private boolean _lazyConstructorCalled = false;
    private static final Logger LOGGER_EVENT = Logger.getLogger(PageEvent.class.getName());

    protected AbstractPage() {
    }

    public int getInvokeCondition() {
        return this._invokeCondition;
    }

    public void setInvokeCondition(int n2) {
        this._invokeCondition = n2;
    }

    public void invalidate() {
        if ((this.getInvokeCondition() & INVOKE_ON_VALIDATE) != 0) {
            this.initialize();
        }
        super.invalidate();
    }

    public void revalidate() {
        if ((this.getInvokeCondition() & INVOKE_ON_VALIDATE) != 0) {
            this.initialize();
        }
        super.revalidate();
    }

    public void paint(Graphics graphics) {
        if ((this.getInvokeCondition() & INVOKE_ON_PAINT) != 0) {
            this.initialize();
        }
        super.paint(graphics);
    }

    public void paintAll(Graphics graphics) {
        if ((this.getInvokeCondition() & INVOKE_ON_PAINT) != 0) {
            this.initialize();
        }
        super.paintAll(graphics);
    }

    public void paintComponents(Graphics graphics) {
        if ((this.getInvokeCondition() & INVOKE_ON_PAINT) != 0) {
            this.initialize();
        }
        super.paintComponents(graphics);
    }

    public void repaint() {
        if ((this.getInvokeCondition() & INVOKE_ON_REPAINT) != 0) {
            this.initialize();
        }
        super.repaint();
    }

    public void repaint(long l2) {
        if ((this.getInvokeCondition() & INVOKE_ON_REPAINT) != 0) {
            this.initialize();
        }
        super.repaint(l2);
    }

    public void repaint(int n2, int n3, int n4, int n5) {
        if ((this.getInvokeCondition() & INVOKE_ON_REPAINT) != 0) {
            this.initialize();
        }
        super.repaint(n2, n3, n4, n5);
    }

    public void repaint(long l2, int n2, int n3, int n4, int n5) {
        if ((this.getInvokeCondition() & INVOKE_ON_REPAINT) != 0) {
            this.initialize();
        }
        super.repaint(l2, n2, n3, n4, n5);
    }

    public void update(Graphics graphics) {
        if ((this.getInvokeCondition() & INVOKE_ON_UPDATE) != 0) {
            this.initialize();
        }
        super.update(graphics);
    }

    public final synchronized void initialize() {
        if (!this._lazyConstructorCalled) {
            this._lazyConstructorCalled = true;
            this.lazyInitialize();
            this.validate();
        }
    }

    public synchronized void reset() {
        this._lazyConstructorCalled = false;
        this.removeAll();
    }

    public void addPageListener(PageListener pageListener) {
        this.listenerList.add(PageListener.class, pageListener);
    }

    public void removePageListener(PageListener pageListener) {
        this.listenerList.remove(PageListener.class, pageListener);
    }

    public PageListener[] getPageListeners() {
        return (PageListener[])this.listenerList.getListeners(PageListener.class);
    }

    public void firePageEvent(int n2) {
        this.firePageEvent(this, n2);
    }

    public void firePageEvent(Object object, int n2) {
        this.initialize();
        if (object == null) {
            object = this;
        }
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n2) {
                case 3199: {
                    LOGGER_EVENT.fine("Page \"" + this + " is opened, source is " + object.getClass().getName());
                    break;
                }
                case 3200: {
                    LOGGER_EVENT.fine("Page \"" + this + " is closing, source is " + object.getClass().getName());
                    break;
                }
                case 3201: {
                    LOGGER_EVENT.fine("Page \"" + this + " is closed, source is " + object.getClass().getName());
                    break;
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PageListener.class) continue;
            this._pageEvent = new PageEvent(object, n2);
            ((PageListener)objectArray[i2 + 1]).pageEventFired(this._pageEvent);
        }
    }

    public void setAllowClosing(boolean bl) {
        this._allowClosing = bl;
    }

    public boolean allowClosing() {
        return this._allowClosing;
    }
}

