/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.colormap;

import com.jidesoft.colormap.AbstractColorMap;
import com.jidesoft.colormap.MutableColorMap;
import com.jidesoft.colormap.SimpleColorMap;
import com.jidesoft.interval.ClosedInterval;
import com.jidesoft.palette.InterpolatedPalette;
import com.jidesoft.palette.MutablePalette;
import com.jidesoft.palette.PaletteFactory;
import com.jidesoft.treemap.TreeMapView;
import com.jidesoft.utils.TableHelper;
import java.awt.Color;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.table.TableModel;

public class ColorMapFactory {
    private final PaletteFactory a;
    private static final ColorMapFactory b = new ColorMapFactory(PaletteFactory.getInstance());

    public static ColorMapFactory getInstance() {
        return b;
    }

    public ColorMapFactory(PaletteFactory paletteFactory) {
        this.a = paletteFactory;
    }

    public MutableColorMap createSequentialColorMap(double d2, double d3) {
        return this.createColorMap(d2, d3, (MutablePalette)this.a.createDefaultSequentialPalette());
    }

    public MutableColorMap createDivergingColorMap(double d2, double d3) {
        return this.createColorMap(d2, d3, (MutablePalette)this.a.createDefaultDivergingPalette());
    }

    public MutableColorMap createSequentialColorMap(Set set) {
        return this.createColorMap(set, false, (MutablePalette)this.a.createDefaultSequentialPalette());
    }

    public MutableColorMap createDivergingColorMap(Set set) {
        return this.createColorMap(set, false, (MutablePalette)this.a.createDefaultDivergingPalette());
    }

    public MutableColorMap createQualitativeColorMap(Set set) {
        return this.createColorMap(set, true, (MutablePalette)this.a.createDefaultQualititativePalette());
    }

    public MutableColorMap createColorMap(double d2, double d3, MutablePalette mutablePalette) {
        return new SimpleColorMap(new ClosedInterval(d2, d3 - d2), mutablePalette);
    }

    public MutableColorMap createColorMap(Set set, boolean bl, MutablePalette mutablePalette) {
        return new SimpleColorMap(set, bl, mutablePalette);
    }

    public MutableColorMap createAlphabeticalColorMap(Set set) {
        boolean bl = AbstractColorMap.d;
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("A");
        treeSet.add("B");
        treeSet.add("C");
        SimpleColorMap simpleColorMap = new SimpleColorMap(treeSet, false, this.a.createDefaultSequentialPalette());
        if (TreeMapView.d != 0) {
            AbstractColorMap.d = !bl;
        }
        return simpleColorMap;
    }

    public MutableColorMap createColorMap(TableModel tableModel, int n2) {
        block5: {
            Number number;
            block4: {
                TableHelper.ColumnStatistics columnStatistics = TableHelper.getColumnStatistics(tableModel, n2);
                number = columnStatistics.getMin();
                if (AbstractColorMap.d) break block4;
                if (number == null) break block5;
                number = columnStatistics.getMax();
            }
            if (number != null) {
                return this.createContinuousColorMap(tableModel, n2);
            }
        }
        return this.createQualitativeColorMap(tableModel, n2);
    }

    public MutableColorMap createContinuousColorMap(TableModel tableModel, int n2) {
        block2: {
            TableHelper.ColumnStatistics columnStatistics;
            block6: {
                double d2;
                double d3;
                block7: {
                    double d4;
                    block5: {
                        double d5;
                        Number number;
                        boolean bl;
                        block4: {
                            block3: {
                                bl = AbstractColorMap.d;
                                if (n2 < 0) break block2;
                                columnStatistics = TableHelper.getColumnStatistics(tableModel, n2);
                                number = columnStatistics.getMin();
                                if (bl) break block3;
                                if (number == null) break block2;
                                number = columnStatistics.getMax();
                            }
                            if (bl) break block4;
                            if (number == null) break block2;
                            number = columnStatistics.getMin();
                        }
                        d4 = (d5 = number.doubleValue() - 0.0) == 0.0 ? 0 : (d5 < 0.0 ? -1 : 1);
                        if (bl) break block5;
                        if (d4 >= 0) break block6;
                        d3 = columnStatistics.getMax().doubleValue();
                        d2 = 0.0;
                        if (bl) break block7;
                        double d6 = d3 - d2;
                        d4 = d6 == 0.0 ? 0 : (d6 > 0.0 ? 1 : -1);
                    }
                    if (d4 <= 0) break block6;
                    d3 = 0.0;
                    d2 = columnStatistics.getMin().doubleValue();
                }
                double d7 = d3 - d2;
                double d8 = columnStatistics.getMax().doubleValue();
                double d9 = Math.max(d7, d8);
                return this.createDivergingColorMap(0.0 - d9, d9);
            }
            return this.createSequentialColorMap(columnStatistics.getMin().doubleValue(), columnStatistics.getMax().doubleValue());
        }
        return null;
    }

    public MutableColorMap createSegmentedColorMap(TableModel tableModel, int n2) {
        block2: {
            TableHelper.ColumnStatistics columnStatistics;
            block6: {
                double d2;
                double d3;
                block7: {
                    double d4;
                    block5: {
                        double d5;
                        Number number;
                        boolean bl;
                        block4: {
                            block3: {
                                bl = AbstractColorMap.d;
                                if (n2 < 0) break block2;
                                columnStatistics = TableHelper.getColumnStatistics(tableModel, n2);
                                number = columnStatistics.getMin();
                                if (bl) break block3;
                                if (number == null) break block2;
                                number = columnStatistics.getMax();
                            }
                            if (bl) break block4;
                            if (number == null) break block2;
                            number = columnStatistics.getMin();
                        }
                        d4 = (d5 = number.doubleValue() - 0.0) == 0.0 ? 0 : (d5 < 0.0 ? -1 : 1);
                        if (bl) break block5;
                        if (d4 >= 0) break block6;
                        d3 = columnStatistics.getMax().doubleValue();
                        d2 = 0.0;
                        if (bl) break block7;
                        double d6 = d3 - d2;
                        d4 = d6 == 0.0 ? 0 : (d6 > 0.0 ? 1 : -1);
                    }
                    if (d4 <= 0) break block6;
                    d3 = 0.0;
                    d2 = columnStatistics.getMin().doubleValue();
                }
                double d7 = d3 - d2;
                double d8 = columnStatistics.getMax().doubleValue();
                double d9 = Math.max(d7, d8);
                double d10 = 0.0 - d9;
                double d11 = d9;
                double d12 = (d10 - columnStatistics.getMin().doubleValue()) / (columnStatistics.getMax().doubleValue() - columnStatistics.getMin().doubleValue());
                double d13 = (d11 - columnStatistics.getMin().doubleValue()) / (columnStatistics.getMax().doubleValue() - columnStatistics.getMin().doubleValue());
                double d14 = (d13 + d12) / 2.0;
                return this.createColorMap(columnStatistics.getMin().doubleValue(), columnStatistics.getMax().doubleValue(), (MutablePalette)new InterpolatedPalette(new InterpolatedPalette.Entry(d12, Color.red), new InterpolatedPalette.Entry(d14, Color.white), new InterpolatedPalette.Entry(d13, new Color(0, 128, 0))));
            }
            return this.createColorMap(columnStatistics.getMin().doubleValue(), columnStatistics.getMax().doubleValue(), (MutablePalette)new InterpolatedPalette(new InterpolatedPalette.Entry(0.0, Color.red), new InterpolatedPalette.Entry(0.5, Color.white), new InterpolatedPalette.Entry(1.0, new Color(0, 128, 0))));
        }
        return null;
    }

    public MutableColorMap createQualitativeColorMap(TableModel tableModel, int n2) {
        block3: {
            TreeSet<Object> treeSet;
            block4: {
                boolean bl = AbstractColorMap.d;
                if (n2 < 0) break block3;
                treeSet = new TreeSet<Object>();
                int n3 = 0;
                if (tableModel == null) break block4;
                int n4 = 0;
                while (n4 < tableModel.getRowCount()) {
                    block5: {
                        block6: {
                            block7: {
                                Object object = tableModel.getValueAt(n4, n2);
                                if (bl) break block5;
                                if (object == null) break block6;
                                boolean bl2 = object instanceof Comparable;
                                if (bl) break block7;
                                if (!bl2) break block6;
                                bl2 = treeSet.add(object);
                            }
                            ++n3;
                        }
                        ++n4;
                    }
                    if (!bl) continue;
                }
            }
            return this.createQualitativeColorMap(treeSet);
        }
        return this.createQualitativeColorMap(Collections.emptySet());
    }
}

