/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.fit.CurveFitter;
import com.jidesoft.chart.fit.Polynomial;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.range.Range;
import java.awt.geom.Point2D;
import java.util.List;
import org.apache.commons.math.linear.RealMatrixImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolynomialFitter
implements CurveFitter {
    private int a;

    public PolynomialFitter(int n2) {
        this.setOrder(n2);
    }

    public void setOrder(int n2) {
        block5: {
            int n3;
            block4: {
                n3 = b;
                if (Polynomial.b != 0) break block4;
                if (n3 != 0) break block5;
                n3 = n2;
            }
            if (n3 < 0) {
                throw new AssertionError();
            }
        }
        this.a = n2;
    }

    @Override
    public Polynomial performRegression(ChartModel chartModel) {
        double d2;
        int n2;
        int n3;
        double[][] dArray;
        int n4;
        block4: {
            n4 = Polynomial.b;
            dArray = new double[this.a + 1][this.a + 1];
            int n5 = 0;
            while (n5 <= this.a) {
                block5: {
                    n3 = 0;
                    if (n4 != 0) break block4;
                    for (n2 = v253200; n2 <= this.a; ++n2) {
                        dArray[n5][n2] = d2 = this.a(chartModel, n5 + n2, 0);
                        if (n4 == 0) {
                            if (n4 == 0) continue;
                        }
                        break block5;
                    }
                    ++n5;
                }
                if (n4 == 0) continue;
            }
            n3 = this.a + 1;
        }
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 <= this.a; ++n2) {
            dArray2[n2] = d2 = this.a(chartModel, n2, 1);
            if (n4 == 0) continue;
        }
        RealMatrixImpl realMatrixImpl = new RealMatrixImpl(dArray);
        double[] dArray3 = realMatrixImpl.solve(dArray2);
        return new Polynomial(dArray3);
    }

    @Override
    public AnnotatedChartModel performRegression(String string, ChartModel chartModel, Range<?> range, int n2) {
        Polynomial polynomial = this.performRegression(chartModel);
        return this.createModel(string, polynomial, range, n2);
    }

    @Override
    public AnnotatedChartModel createModel(Polynomial polynomial, Range<?> range, int n2) {
        return this.createModel(null, polynomial, range, n2);
    }

    @Override
    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Range<?> range, int n2) {
        DefaultChartModel defaultChartModel;
        block2: {
            int n3 = Polynomial.b;
            double d2 = range.minimum();
            double d3 = range.maximum();
            DefaultChartModel defaultChartModel2 = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
            double d4 = (d3 - d2) / (double)(n2 - 1);
            for (int i2 = 0; i2 < n2; ++i2) {
                double d5 = d2 + (double)i2 * d4;
                double d6 = polynomial.eval(d5);
                defaultChartModel = defaultChartModel2.addPoint(d5, d6);
                if (n3 == 0) {
                    if (n3 == 0) continue;
                }
                break block2;
            }
            defaultChartModel = defaultChartModel2;
        }
        return defaultChartModel;
    }

    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Double[] doubleArray) {
        DefaultChartModel defaultChartModel;
        block2: {
            int n2 = Polynomial.b;
            DefaultChartModel defaultChartModel2 = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
            for (Double d2 : doubleArray) {
                double d3 = polynomial.eval(d2);
                defaultChartModel = defaultChartModel2.addPoint((double)d2, d3);
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            defaultChartModel = defaultChartModel2;
        }
        return defaultChartModel;
    }

    public Polynomial performRegression(List<? extends Point2D> list) {
        throw new UnsupportedOperationException();
    }

    private double a(ChartModel chartModel, int n2, int n3) {
        double d2;
        block2: {
            int n4 = Polynomial.b;
            double d3 = 0.0;
            for (Chartable chartable : chartModel) {
                d2 = d3 + Math.pow(chartable.getX().position(), n2) * Math.pow(chartable.getY().position(), n3);
                if (n4 == 0) {
                    d3 = d2;
                    if (n4 == 0) continue;
                }
                break block2;
            }
            d2 = d3;
        }
        return d2;
    }
}

