/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartType;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.LegendItem;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.a;
import com.jidesoft.chart.l;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.Named;
import com.jidesoft.range.Category;
import com.jidesoft.range.Positionable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Legend
extends JPanel
implements Drawable,
Frontable {
    private static final long serialVersionUID = 3209957448711005879L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int LEADING = 3;
    public static final int RIGHT = 2;
    public static final int TRAILING = 4;
    public static final String PROPERTY_GENERATE_FROM_POINTS = "GenerateFromPoints";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_TITLE_COLOR = "titleColor";
    public static final String PROPERTY_COLUMNS = "columns";
    public static final String PROPERTY_KEY_LABEL_GAP = "keyLabelGap";
    public static final String PROPERTY_LABEL_COLOR = "labelColor";
    public static final String PROPERTY_LEGEND_BACKGROUND = "legendBackground";
    public static final String PROPERTY_ORDER_REVERSED = "order reversed";
    public static final String PROPERTY_AT_FRONT = "At Front";
    public static final String PROPERTY_TITLE_LABEL = "Title Label";
    public static final String PROPERTY_ROLLOVER_MODEL = "Rollover Model";
    private static final Logger a = Logger.getLogger(Legend.class.getName());
    private GridBagLayout b;
    private int c;
    private List<WeakReference<Chart>> d;
    private Set<ChartModel> e;
    private Set<Chartable> f;
    private List<ChartModel> g;
    private List<LegendItem> h;
    private String i;
    private JLabel j;
    private Color k;
    private Color l;
    private long m;
    private PropertyChangeListener n;
    private boolean o;
    private boolean p;
    private Border q;
    private Paint r;
    private boolean s;
    private ChartModel t;
    private int u;

    public Legend() {
        this(null, 1);
    }

    public Legend(boolean bl, int n2) {
        this(null, 0);
        if (bl) {
            this.setLayout(new a(n2));
        }
    }

    public Legend(Chart chart) {
        this(chart, 1);
    }

    public Legend(Chart chart, boolean bl) {
        this(chart, 0);
        if (bl) {
            this.setLayout(new a());
        }
    }

    public Legend(Chart chart, boolean bl, int n2) {
        this(chart, 0);
        if (bl) {
            this.setLayout(new a(n2));
        }
    }

    public Legend(Chart chart, int n2) {
        block3: {
            Legend legend;
            block2: {
                this.b = new GridBagLayout();
                this.c = 1;
                this.d = new ArrayList<WeakReference<Chart>>();
                this.e = new HashSet<ChartModel>();
                this.f = new HashSet<Chartable>();
                this.g = new ArrayList<ChartModel>();
                this.h = new ArrayList<LegendItem>();
                this.j = null;
                this.k = null;
                this.l = null;
                this.o = false;
                this.p = false;
                this.q = null;
                this.r = null;
                this.s = true;
                this.u = 0;
                this.c = n2;
                this.setLayout(this.b);
                this.setBorder(BorderFactory.createLineBorder(Color.gray));
                legend = this;
                if (Orientation.b != 0) break block2;
                legend.n = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        block4: {
                            block3: {
                                boolean bl;
                                block2: {
                                    String string = propertyChangeEvent.getPropertyName();
                                    bl = "Model".equals(string);
                                    if (Orientation.b != 0) break block2;
                                    if (bl) break block3;
                                    bl = "ChartStyle".equals(string);
                                }
                                if (!bl) break block4;
                            }
                            Legend.this.updateLegend();
                        }
                    }
                };
                if (chart == null) break block3;
                legend = this;
            }
            legend.addChart(chart);
        }
        b_ b_2 = new b_(){

            public void mouseMoved(MouseEvent mouseEvent) {
                block8: {
                    Object Source;
                    block9: {
                        Component component;
                        int n2;
                        block7: {
                            boolean bl;
                            Component component2;
                            block6: {
                                n2 = Orientation.b;
                                Point point = mouseEvent.getPoint();
                                Component component3 = component2 = Legend.this.getComponentAt(point);
                                if (n2 == 0) {
                                    if (component3 == null) {
                                        return;
                                    }
                                    component3 = component2;
                                }
                                bl = component3 instanceof JLabel;
                                if (n2 != 0) break block6;
                                if (bl) {
                                    component2 = ((JLabel)component2).getLabelFor();
                                }
                                component = component2;
                                if (n2 != 0) break block7;
                                bl = component instanceof LegendItem;
                            }
                            if (!bl) break block8;
                            component = component2;
                        }
                        LegendItem legendItem = (LegendItem)((Object)component);
                        Source = legendItem.getSource();
                        if (n2 != 0) break block9;
                        if (!(Source instanceof ChartModel)) break block8;
                        Source = legendItem.getSource();
                    }
                    ChartModel chartModel = (ChartModel)Source;
                    Legend.this.a(chartModel);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                Legend.this.a(null);
            }
        };
        this.addMouseListener(b_2);
        this.addMouseMotionListener(b_2);
    }

    public int getKeyLabelGap() {
        return this.u;
    }

    public void setKeyLabelGap(int n2) {
        int n3 = this.u;
        this.u = n2;
        this.firePropertyChange(PROPERTY_KEY_LABEL_GAP, n3, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Paint getLegendBackground() {
        Paint paint;
        Legend legend = this;
        if (Orientation.b == 0) {
            if (legend.r == null) {
                paint = this.getBackground();
                return paint;
            }
            legend = this;
        }
        paint = legend.r;
        return paint;
    }

    public void setLegendBackground(Paint paint) {
        Paint paint2 = this.r;
        this.r = paint;
        this.repaint();
        this.firePropertyChange(PROPERTY_LEGEND_BACKGROUND, paint2, paint);
    }

    public Color getLabelColor() {
        return this.k;
    }

    public void setLabelColor(Color color) {
        Color color2 = this.k;
        this.k = color;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_LABEL_COLOR, color2, color);
    }

    public Color getTitleColor() {
        return this.l;
    }

    public void setTitleColor(Color color) {
        Color color2 = this.l;
        this.l = color;
        Legend legend = this;
        if (Orientation.b == 0) {
            if (legend.j != null) {
                this.j.setForeground(color);
            }
            this.updateLegend();
            legend = this;
        }
        legend.firePropertyChange(PROPERTY_TITLE_COLOR, color2, color);
    }

    private void a(ChartModel chartModel) {
        ChartModel chartModel2 = this.t;
        this.t = chartModel;
        this.firePropertyChange(PROPERTY_ROLLOVER_MODEL, chartModel2, chartModel);
    }

    public void addExcludedModels(ChartModel ... chartModelArray) {
        Collections.addAll(this.e, chartModelArray);
        this.updateLegend();
    }

    public void removeExcludedModels(ChartModel ... chartModelArray) {
        block2: {
            int n2 = Orientation.b;
            for (ChartModel chartModel : chartModelArray) {
                this.e.remove(chartModel);
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            this.updateLegend();
        }
    }

    public void clearExcludedModels() {
        this.e.clear();
        this.updateLegend();
    }

    public Legend addIncludedModel(ChartModel chartModel) {
        this.g.add(chartModel);
        this.updateLegend();
        return this;
    }

    public Legend removeIncludedModel(ChartModel chartModel) {
        this.g.remove(chartModel);
        this.updateLegend();
        return this;
    }

    public Legend addLegendItem(LegendItem legendItem) {
        this.h.add(legendItem);
        this.updateLegend();
        return this;
    }

    public Legend removeLegendItem(LegendItem legendItem) {
        this.h.remove(legendItem);
        this.updateLegend();
        return this;
    }

    public void addExcludedPoints(Chartable ... chartableArray) {
        Collections.addAll(this.f, chartableArray);
        this.updateLegend();
    }

    public void removeExcludedPoints(Chartable ... chartableArray) {
        block2: {
            int n2 = Orientation.b;
            for (Chartable chartable : chartableArray) {
                this.f.remove(chartable);
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            this.updateLegend();
        }
    }

    public void clearExcludedPoints() {
        this.f.clear();
    }

    @Override
    public void setBorder(Border border) {
        this.q = border;
        this.updateLegend();
    }

    public void addChart(Chart chart) {
        WeakReference<Chart> weakReference = new WeakReference<Chart>(chart);
        this.d.add(weakReference);
        chart.addPropertyChangeListener(this.n);
        this.updateLegend();
    }

    public void removeChart(Chart chart) {
        Chart chart2;
        block3: {
            int n2 = Orientation.b;
            for (int i2 = this.d.size() - 1; i2 >= 0; --i2) {
                Chart chart3;
                WeakReference<Chart> weakReference = this.d.get(i2);
                chart2 = chart3 = (Chart)weakReference.get();
                if (n2 == 0) {
                    Object object;
                    if (n2 != 0) continue;
                    if (chart2 != null) {
                        object = chart;
                        if (n2 != 0 || !object.equals(chart3)) continue;
                    }
                    object = this.d.remove(i2);
                    if (n2 == 0) continue;
                }
                break block3;
            }
            chart2 = chart;
        }
        chart2.removePropertyChangeListener(this.n);
    }

    public void setColumns(int n2) {
        int n3 = this.c;
        this.c = n2;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_COLUMNS, n3, n2);
    }

    public void clear() {
        this.d.clear();
    }

    public String getTitle() {
        return this.i;
    }

    public void setTitle(String string) {
        String string2;
        block7: {
            int n2;
            block6: {
                block5: {
                    n2 = Orientation.b;
                    string2 = this.i;
                    if (n2 != 0) break block5;
                    if (string != null) break block6;
                    this.j = null;
                }
                if (n2 == 0) break block7;
            }
            Legend legend = this;
            if (n2 == 0) {
                if (legend.j == null) {
                    this.j = this.createLegendTitle(string);
                }
                legend = this;
            }
            legend.i = string;
        }
        this.firePropertyChange(PROPERTY_TITLE, string2, string);
        this.updateLegend();
    }

    public JLabel getTitleLabel() {
        return this.j;
    }

    public void setTitleLabel(JLabel jLabel) {
        JLabel jLabel2 = this.j;
        this.j = jLabel;
        this.firePropertyChange(PROPERTY_TITLE_LABEL, jLabel2, jLabel);
    }

    public boolean isGenerateFromPoints() {
        return this.o;
    }

    public void setGenerateFromPoints(boolean bl) {
        boolean bl2 = this.o;
        this.o = bl;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_GENERATE_FROM_POINTS, bl2, bl);
    }

    public boolean isOrderReversed() {
        return this.p;
    }

    public void setOrderReversed(boolean bl) {
        boolean bl2 = this.p;
        this.p = bl;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_ORDER_REVERSED, bl2, bl);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateLegend();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void updateLegend() {
        block37: {
            block29: {
                block28: {
                    var9_1 = Orientation.b;
                    this.removeAll();
                    super.setBorder(null);
                    v0 = this;
                    if (var9_1 == 0) {
                        if (v0.j != null) {
                            var1_2 = new GridBagConstraints(0, 0, this.c, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0);
                            this.add((Component)this.j, var1_2);
                        }
                        v0 = this;
                    }
                    if (v0.d == null) {
                        return;
                    }
                    var1_2 = new ArrayList<E>();
                    for (Object var3_4 : this.d) {
                        block31: {
                            block27: {
                                block34: {
                                    block32: {
                                        block33: {
                                            block30: {
                                                v1 /* !! */  = var3_4;
                                                if (var9_1 != 0) ** GOTO lbl20
                                                if (v1 /* !! */  == null) {
                                                    v2 = null;
                                                } else {
                                                    v1 /* !! */  = var3_4.get();
lbl20:
                                                    // 2 sources

                                                    v2 = (Chart)v1 /* !! */ ;
                                                }
                                                var4_6 = v2;
                                                v3 = var4_6;
                                                if (var9_1 != 0) break block30;
                                                if (v3 == null) break block31;
                                                v3 = var4_6;
                                            }
                                            var5_8 = v3.getChartType();
                                            if (var9_1 != 0) break block32;
                                            if (var5_8 == ChartType.PIE) break block33;
                                            v4 = this.o;
                                            if (var9_1 != 0) break block32;
                                            if (!v4) break block34;
                                        }
                                        v4 = var1_2.addAll(this.a((Chart)var4_6));
                                    }
                                    if (var9_1 == 0) break block31;
                                }
                                var6_9 = new ArrayList<ChartModel>(var4_6.getModels());
                                for (ChartModel var8_11 : this.g) {
                                    var6_9.add((ChartModel)var8_11);
                                    if (var9_1 == 0) {
                                        if (var9_1 == 0) continue;
                                    }
                                    break block27;
                                }
                                v5 = this.isOrderReversed();
                                if (var9_1 != 0) break block31;
                                if (v5) {
                                    Collections.reverse(var6_9);
                                }
                            }
                            v5 = var1_2.addAll(this.a((Chart)var4_6, (List<ChartModel>)var6_9));
                        }
                        if (var9_1 == 0) continue;
                    }
                    var2_3 = new ArrayList<LegendItem>(this.h);
                    if (this.isOrderReversed()) {
                        Collections.reverse(var2_3);
                    }
                    var3_4 = var2_3.iterator();
                    while (var3_4.hasNext()) {
                        var4_6 = (LegendItem)var3_4.next();
                        v6 = var1_2.add(this.createLegendPair((LegendItem)var4_6, this.createLegendLabel(var4_6.getLabel())));
                        if (var9_1 == 0) {
                            if (var9_1 == 0) continue;
                        }
                        break block28;
                    }
                    v6 = 0;
                }
                var3_5 = v6;
                var4_7 = 1;
                var5_8 = var1_2.iterator();
                while (var5_8.hasNext()) {
                    block36: {
                        block35: {
                            var6_9 = (l)var5_8.next();
                            var7_10 = new GridBagConstraints(var3_5, var4_7, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 10, 0);
                            this.add((Component)var6_9, var7_10);
                            ++var3_5;
                            v7 = this.c;
                            if (var9_1 != 0) break block29;
                            if (var9_1 != 0) break block35;
                            if (v7 <= 0) break block36;
                            v8 = var3_5;
                        }
                        if (var9_1 == 0 && v8 >= this.c) {
                            ++var4_7;
                            v8 = var3_5 = 0;
                        }
                    }
                    if (var9_1 == 0) continue;
                }
                v9 = this;
                if (var9_1 != 0) break block37;
                v7 = v9.getComponentCount();
            }
            if (v7 > 0) {
                super.setBorder(this.q);
            }
            v9 = this;
        }
        v9.m = System.currentTimeMillis();
    }

    private List<l> a(Chart chart) {
        int n2;
        int n3 = Orientation.b;
        ArrayList<l> arrayList = new ArrayList<l>();
        ChartModel chartModel = chart.getModel();
        int n4 = 0;
        int n5 = 1;
        int n6 = this.isOrderReversed();
        if (n3 == 0) {
            if (n6 != 0) {
                n4 = chartModel.getPointCount() - 1;
                n5 = -1;
            }
            n6 = n2 = n4;
        }
        while (n2 >= 0 && chartModel != null && n2 < chartModel.getPointCount()) {
            Chartable chartable = chartModel.getPoint(n2);
            LegendItem legendItem = this.createPointLegendItem(chartable, chartModel, chart);
            JLabel jLabel = this.createLegendLabel(chartable);
            l l2 = this.createLegendPair(legendItem, jLabel);
            arrayList.add(l2);
            n2 += n5;
            if (n3 == 0) continue;
        }
        return arrayList;
    }

    protected LegendItem createPointLegendItem(Chartable chartable, ChartModel chartModel, Chart chart) {
        return new e_(chartable, chartModel, chart);
    }

    private List<l> a(Chart chart, List<ChartModel> list) {
        int n2 = Orientation.b;
        ArrayList<l> arrayList = new ArrayList<l>();
        for (ChartModel chartModel : list) {
            block4: {
                Legend legend;
                block3: {
                    legend = this;
                    if (n2 != 0) break block3;
                    if (legend.e.contains(chartModel)) break block4;
                    legend = this;
                }
                LegendItem legendItem = legend.createModelLegendItem(chartModel, chart);
                JLabel jLabel = this.createLegendLabel(chartModel);
                l l2 = this.createLegendPair(legendItem, jLabel);
                arrayList.add(l2);
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    protected LegendItem createModelLegendItem(ChartModel chartModel, Chart chart) {
        return new d_(chartModel, chart);
    }

    protected l createLegendPair(LegendItem legendItem, JLabel jLabel) {
        return new l(this, legendItem, jLabel);
    }

    /*
     * Unable to fully structure code
     */
    protected JLabel createLegendLabel(Chartable var1_1) {
        block10: {
            block9: {
                var5_2 = Orientation.b;
                v0 = var1_1;
                if (var5_2 == 0) {
                    if (v0 instanceof Named) {
                        v0 = var1_1;
                        if (var5_2 == 0) {
                            var2_3 = ((Named)v0).getName();
                            if (var2_3 != null) {
                                return new JLabel((String)var2_3);
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    } else lbl-1000:
                    // 3 sources

                    {
                        v0 = var1_1;
                    }
                }
                var2_3 = v0.getX();
                var3_4 = Double.toString(var2_3.position());
                v1 = var2_3;
                if (var5_2 != 0) break block9;
                if (!(v1 instanceof Category)) break block10;
                v1 = var2_3;
            }
            var4_5 = (Category)v1;
            var3_4 = var4_5.getName();
        }
        return new JLabel(var3_4);
    }

    protected JLabel createLegendLabel(ChartModel chartModel) {
        return this.createLegendLabel(chartModel.getName());
    }

    protected JLabel createLegendLabel(String string) {
        JLabel jLabel = new JLabel(string, 2);
        if (Orientation.b == 0) {
            if (this.k != null) {
                jLabel.setForeground(this.k);
            }
            jLabel.setFont(this.getFont());
        }
        return jLabel;
    }

    protected JLabel createLegendTitle(String string) {
        JLabel jLabel = new JLabel(string, 0);
        if (Orientation.b == 0) {
            if (this.l != null) {
                jLabel.setForeground(this.l);
            }
            jLabel.setFont(this.getFont());
        }
        return jLabel;
    }

    @Override
    public boolean isAtFront() {
        return this.s;
    }

    @Override
    public void setAtFront(boolean bl) {
        boolean bl2 = this.s;
        this.s = bl;
        this.firePropertyChange(PROPERTY_AT_FRONT, bl2, bl);
    }

    @Override
    public void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.validate();
        this.doLayout();
        this.setSize(this.getPreferredSize());
        int n2 = this.getX();
        int n3 = this.getY();
        graphics.translate(n2, n3);
        this.print(graphics);
        graphics.translate(-n2, -n3);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void paintComponent(Graphics var1_1) {
        block6: {
            block5: {
                var6_2 = Orientation.b;
                v0 = this;
                if (var6_2 != 0) break block5;
                if (v0.isOpaque()) break block6;
                v0 = this;
            }
            super.paintComponent(var1_1);
            return;
        }
        var2_3 = (Graphics2D)var1_1;
        v1 = this;
        if (var6_2 != 0) ** GOTO lbl17
        if (v1.r == null) {
            v2 = this.getBackground();
        } else {
            v1 = this;
lbl17:
            // 2 sources

            v2 = v1.r;
        }
        var3_4 = v2;
        var4_5 = this.getWidth();
        var5_6 = this.getHeight();
        var2_3.setPaint(var3_4);
        var2_3.fillRect(0, 0, var4_5, var5_6);
        this.setOpaque(false);
        super.paintComponent(var1_1);
        this.setOpaque(true);
    }

    class b_
    implements MouseListener,
    MouseMotionListener {
        b_() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class e_
    extends JComponent
    implements LegendItem<Chartable, ChartModel> {
        private static final long serialVersionUID = 2720860066814394586L;
        private Chartable a;
        private ChartModel b;
        private Chart c;
        private String d;

        public e_(Chartable chartable, ChartModel chartModel, Chart chart) {
            this.setOpaque(false);
            this.a = chartable;
            this.b = chartModel;
            this.c = chart;
            Dimension dimension = new Dimension(30, 20);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
        }

        @Override
        public String getLabel() {
            Object object;
            block4: {
                e_ e_2;
                block8: {
                    block5: {
                        Object object2;
                        boolean bl;
                        int n2;
                        block6: {
                            block7: {
                                n2 = Orientation.b;
                                object = this.d;
                                if (n2 != 0) break block4;
                                if (object != null) break block5;
                                Positionable positionable = this.a.getX();
                                this.d = Double.toString(positionable.position());
                                bl = positionable instanceof Category;
                                if (n2 != 0) break block6;
                                if (!bl) break block7;
                                object2 = (Category)positionable;
                                this.d = ((Category)object2).getName();
                                if (n2 == 0) break block5;
                            }
                            e_2 = this;
                            if (n2 != 0) break block8;
                            bl = e_2.a instanceof Named;
                        }
                        if (!bl) break block5;
                        object = object2 = ((Named)((Object)this.a)).getName();
                        if (n2 != 0) break block4;
                        if (object != null) {
                            this.d = object2;
                        }
                    }
                    e_2 = this;
                }
                object = e_2.d;
            }
            return object;
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public Chartable getItem() {
            return this.a;
        }

        @Override
        public ChartModel getSource() {
            return this.b;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Object object;
            ChartStyle chartStyle;
            Graphics2D graphics2D;
            int n2;
            block7: {
                Highlight highlight;
                Chartable chartable;
                block6: {
                    n2 = Orientation.b;
                    graphics2D = (Graphics2D)graphics.create();
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    Dimension dimension = this.getSize();
                    int n3 = dimension.height;
                    int n4 = graphics.getFontMetrics().getHeight();
                    graphics2D.setClip(0, n3 / 2 - n4 / 2, 30, n4);
                    chartStyle = this.c.getStyle(this.b);
                    chartable = this.a;
                    if (n2 != 0) break block6;
                    if (!(chartable instanceof Highlightable)) break block7;
                    chartable = this.a;
                }
                if ((highlight = (object = (Highlightable)((Object)chartable)).getHighlight()) != null) {
                    chartStyle = this.c.getHighlightStyle(highlight);
                }
            }
            ChartStyle chartStyle2 = chartStyle;
            if (n2 == 0) {
                if (chartStyle2 == null) {
                    chartStyle = ChartStyle.DEFAULT_STYLE;
                    chartStyle.setBarPaint(Color.black);
                }
                chartStyle2 = chartStyle;
            }
            object = chartStyle2.getBarPaint();
            graphics2D.setPaint((Paint)object);
            graphics2D.fillRect(5, 0, 20, 20);
            graphics2D.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class d_
    extends JComponent
    implements LegendItem<ChartModel, ChartModel> {
        private static final long serialVersionUID = 8445473530598990518L;
        private ChartModel a;
        private Chart b;
        private ChartStyle c;

        public d_(ChartModel chartModel, Chart chart) {
            block3: {
                block2: {
                    this.setOpaque(false);
                    this.a = chartModel;
                    this.b = chart;
                    this.c = chart.getStyle(chartModel);
                    d_ d_2 = this;
                    if (Orientation.b != 0) break block2;
                    if (d_2.c != null) break block3;
                    d_2 = this;
                }
                d_2.c = ChartStyle.DEFAULT_STYLE;
            }
            int n2 = 1 + Math.max(20, this.c.getPointSize());
            int n3 = 1 + Math.max(30, this.c.getPointSize());
            Dimension dimension = new Dimension(n3, n2);
            this.setMinimumSize(dimension);
            this.setSize(dimension);
            this.setPreferredSize(dimension);
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public String getLabel() {
            return this.a.getName();
        }

        @Override
        public ChartModel getSource() {
            return this.a;
        }

        @Override
        public ChartModel getItem() {
            return this.a;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D;
            block14: {
                d_ d_2;
                Object object;
                int n2;
                int n3;
                block13: {
                    boolean bl;
                    block12: {
                        int n4;
                        block9: {
                            block10: {
                                block11: {
                                    n4 = Orientation.b;
                                    graphics2D = (Graphics2D)graphics.create();
                                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                    Dimension dimension = this.getSize();
                                    n3 = dimension.height;
                                    n2 = dimension.width;
                                    ChartStyle chartStyle = this.c;
                                    if (n4 == 0) {
                                        if (chartStyle == null) {
                                            return;
                                        }
                                        chartStyle = this.c;
                                    }
                                    bl = chartStyle.isLinesVisible();
                                    if (n4 != 0) break block9;
                                    if (!bl) break block10;
                                    object = this.b.getLineRenderer(this.a);
                                    if (this.c.getLineFill() == null) break block11;
                                    int[] nArray = new int[]{5, 5 + (n2 - 10) / 2, n2 - 5};
                                    int[] nArray2 = new int[]{3 * n3 / 4, (int)Math.round((double)n3 / 2.0) - 1, 3 * n3 / 4};
                                    object.renderLine(graphics2D, null, nArray, nArray2, this.c);
                                    if (n4 == 0) break block10;
                                }
                                object.renderLine(graphics2D, null, new int[]{5, n2 - 5}, new int[]{n3 / 2, n3 / 2}, this.c);
                            }
                            bl = this.c.isPointsVisible();
                        }
                        if (n4 != 0) break block12;
                        if (bl) {
                            object = this.b.getPointRenderer(this.a);
                            object.renderPoint(graphics2D, this.b, this.a, null, false, false, false, n2 / 2, n3 / 2);
                        }
                        d_2 = this;
                        if (n4 != 0) break block13;
                        bl = d_2.c.isBarsVisible();
                    }
                    if (!bl) break block14;
                    d_2 = this;
                }
                object = d_2.b.getBarRenderer(this.a);
                object.renderBar(graphics2D, this.b, this.a, null, false, false, false, 5, n3 / 4, n2 - 10, n3 / 2);
            }
            graphics2D.dispose();
        }
    }
}

